% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_helpers.R
\name{QCstats}
\alias{QCstats}
\title{Load ORFik QC Statistics report}
\usage{
QCstats(df, path = file.path(QCfolder(df), "STATS.csv"))
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{path}{path to QC statistics report, default:
file.path(dirname(df$filepath[1]), "/QC_STATS/STATS.csv")}
}
\value{
data.table of QC report or NULL if not exists
}
\description{
Loads the pre / post alignment statistcs made in ORFik.
}
\details{
The ORFik QC uses the aligned files (usually bam files),
fastp and STAR log files
combined with annotation to create relevant statistics.
}
\examples{
df <- ORFik.template.experiment()
## First make QC report
# QCreport(df)
# stats <- QCstats(df)
}
\seealso{
Other QC report: 
\code{\link{QCplots}()},
\code{\link{QCreport}()}
}
\concept{QC report}
