\name{fdr.spatial}
\alias{fdr.spatial} 
\title{Assessment of the significance of spatial bias}	
\description{This function assesses the significance of spatial bias by a one-sided random permutation test.  This is 
achieved by comparing the observed average values of logged fold-changes within a spot's spatial neighbourhood
with an empirical distribution generated by random permutation. The significance of spatial bias is given
by the false discovery rate.}
\usage{fdr.spatial(X,delta=2,N=100,av="median",edgeNA=FALSE)}
\arguments{\item{X}{matrix of logged fold changes. 
             For alternative input format, see \code{\link{fdr.spatial2}}.}
              \item{delta}{integer determining the size of spot neighbourhoods 
            (\code{(2*delta+1)x(2*delta+1)}).}
           \item{N}{number of random permutations performed for generation of empirical background distribution}
            \item{av}{averaging of \code{M} within neighbourhood by 
            \emph{mean} or \emph{median} (default)}      
           \item{edgeNA}{treatment of edges of array: For \code{edgeNA=TRUE},
               the significance of a neighbourhood (defined by a sliding window) is set to NA, 
               if the neighbourhood extends over the edges of the matrix.} 
}
\details{The function \code{fdr.spatial} assesses the significance  of spatial bias using a one-sided random permutation test.
          The null hypothesis states random spotting i.e. the independence of log ratio \code{M} 
          and spot location. First, a neighbourhood of a spot is defined  by a two dimensional square window 
          of chosen size ((2*delta+1)x(2*delta+1)). Next, a test statistic is defined by calculating 
           the \emph{median} or \emph{mean} of \code{M} within
           a symmetrical spot's neighbourhood. An empirical distribution of  \eqn{\bar{M}}{median/mean of \code{M}} is generated 
           based
           \code{N} random permutations of the spot locations on the array. The randomisation and calculation of 
            \eqn{\bar{M}}{median/mean of \code{M}} is repeated \code{N} times.
          Comparing this empirical distribution of  \eqn{\bar{M}}{median/mean of \code{M}}
           with the observed distribution of  \eqn{\bar{M}}{median/mean of \code{M}}, 
           the independence of \code{M} and spot location
           can be  assessed. If \code{M} is independent of spot's location, 
           the empirical distribution can be  expected to be
           distributed around its mean value. To assess the significance of observing positive deviations of 
           \eqn{\bar{M}}{median/mean of \code{M}},
          the false discovery rate (\emph{FDR}) is used. It  indicates the expected proportion of false discoveries 
          among rejected null hypotheses.  It is defined as \eqn{FDR=q\ast T/s}{FDR=q*T/s}, 
          where \emph{q} is the fraction of \eqn{\bar{M}}{median/mean of \code{M}} larger than  chosen threshold  \emph{c}
         for the empirical distribution, \code{s} is the number of neighbourhoods with  
          \eqn{\bar{M}>c}{(median/mean of \code{M})> c} 
           for the distribution derived from the original data and \code{T} 
           is the total number of neighbourhoods on the array. FDRs equal zero are set to
          \eqn{FDR=1/T\ast N}{FDR=1/T*N}. 
          Varying threshold \emph{c} determines the FDR for each spot neighbourhood. Correspondingly, the significance
          of observing negative deviations of \eqn{\bar{M}}{median/mean of \code{M}} can be determined. }

\value{A list of matrices containing the false discovery rates for positive (\code{FDRp}) 
        and negative (\code{FDRn}) deviations of
       \eqn{\bar{M}}{median/mean of \code{M}} of the spot's neighbourhood is produced.}
\note{The same functionality but with our input and output formats is offered by \code{\link{fdr.spatial}}}
\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{ \code{\link{p.spatial}}, \code{\link{fdr.int}}, \code{\link{sigxy.plot}},  \code{\link{fdr.spatial2}}}

\examples{

# To run these examples, delete the comment signs before the commands.
#
# LOADING DATA
# data(sw)
# M <- v2m(maM(sw)[,1],Ngc=maNgc(sw),Ngr=maNgr(sw),
#                Nsc=maNsc(sw),Nsr=maNsr(sw),main="MXY plot of SW-array 1")
#
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
# For this illustration, N was chosen rather small. For "real" analysis, it should be larger.
# FDR <- fdr.spatial(M,delta=2,N=10,av="median",edgeNA=TRUE)
# sigxy.plot(FDR$FDRp,FDR$FDRn,color.lim=c(-5,5),main="FDR")
#
# LOADING NORMALISED DATA
# data(sw.olin)
# M<- v2m(maM(sw.olin)[,1],Ngc=maNgc(sw.olin),Ngr=maNgr(sw.olin),
#                Nsc=maNsc(sw.olin),Nsr=maNsr(sw.olin),main="MXY plot of SW-array 1")
#
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
# FDR <- fdr.spatial(M,delta=2,N=10,av="median",edgeNA=TRUE)
# VISUALISATION OF RESULTS
# sigxy.plot(FDR$FDRp,FDR$FDRn,color.lim=c(-5,5),main="FDR")

}



\keyword{nonparametric}
\keyword{univar}
\keyword{htest}




