 \name{fdr.int2}
\alias{fdr.int2} 
\title{Assessment of the significance of  intensity-dependent bias}	
\description{This function assesses the significance of intensity-dependent bias by an one-sided random permutation test.  The observed average values of logged fold-changes within an intensity neighbourhood are compared to an empirical distribution generated by random  permutation. The significance  is given by the false discovery rate.}
\usage{fdr.int2(object,delta=50,N=100,av="median")}
\arguments{\item{object}{object of class marrayRaw or marrayNorm}
           \item{delta}{integer determining the size of the neighbourhood. The actual window size is 
            (\code{2 * delta+1}).}
           \item{N}{number of random permutations performed for generation of empirical distribution}
           \item{av}{averaging of \code{M} within neighbourhood by \emph{mean} or \emph{median} (default)}
          }

\details{This function \code{fdr.int2} is basically the same as \code{fdr.int} except for 
differences  in their in- and output format. For the details about the functionality, see \code{\link{fdr.int}}.  }
\note{This function will be merged with \code{fdr.int} in future versions.}
\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{\code{\link{fdr.int}}, \code{\link{p.int2}}, \code{\link{sigint.plot2}}}
\examples{

# To run these examples, delete the comment signs (#) in front of the commands.
#
# LOADING DATA NOT-NORMALISED
# data(sw)
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
# For this example, N was chosen rather small. For "real" analysis, it should be larger.
# FDR <- fdr.int2(sw,delta=50,N=10,av="median")
# VISUALISATION OF RESULTS
# sigint.plot2(sw[,1],FDR$FDRp[[1]],FDR$FDRn[[1]],c(-5,-5)) # array 1
# sigint.plot2(sw[,4],FDR$FDRp[[4]],FDR$FDRn[[4]],c(-5,-5)) # array 4

}
\keyword{nonparametric}
\keyword{univar}
\keyword{htest}




