% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extractPromoters}
\alias{extractPromoters}
\title{Extract promoter}
\usage{
extractPromoters(OGREDataSet, name, upstream = 2000, downstream = 200)
}
\arguments{
\item{OGREDataSet}{An OGREDataSet}

\item{name}{\code{character} Name of the GRanges object}

\item{upstream}{\code{int} (positive) upstream=2000(default)}

\item{downstream}{\code{int} (positive) downstream=200(default)}
}
\value{
OGREDataSet
}
\description{
A wrapper of \code{GenomicRanges::promoters()} to extract promoter regions of
a GRanges object stored in a OGREDataSet
}
\examples{
myOGRE <- makeExampleOGREDataSet()
myOGRE <- loadAnnotations(myOGRE)
myOGRE <- extractPromoters(myOGRE,"genes", upstream=2000, downstream=200)
}
