% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputUtils.R
\name{writeNormalizedDatasets}
\alias{writeNormalizedDatasets}
\title{Write normalization matrices to file}
\usage{
writeNormalizedDatasets(
  nr,
  jobdir,
  includePairwiseComparisons = FALSE,
  includeCvCol = FALSE,
  includeAnovaP = FALSE,
  normSuffix = "-normalized.txt",
  rawdataName = "submitted_rawdata.txt"
)
}
\arguments{
\item{nr}{Results object.}

\item{jobdir}{Path to output directory.}

\item{includePairwiseComparisons}{Include p-values for pairwise comparisons.}

\item{includeCvCol}{Include CV column in output.}

\item{includeAnovaP}{Include ANOVA p-value in output.}

\item{normSuffix}{String used to name output together with normalization names.}

\item{rawdataName}{Name of output raw data file.}
}
\value{
None
}
\description{
Outputs each of the normalized datasets to the specified directory.
}
\examples{
data(example_summarized_experiment)
normObj <- getVerifiedNormalyzerObject("job_name", example_summarized_experiment)
normResults <- normMethods(normObj)
normResultsWithEval <- analyzeNormalizations(normResults)
outputDir <- tempdir()
writeNormalizedDatasets(normResultsWithEval, outputDir)
}
