% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbExtract.R
\name{biopax2igraph}
\alias{biopax2igraph}
\title{Processes BioPAX objects into igraph objects}
\usage{
biopax2igraph(
  biopax,
  parse.as = c("metabolic", "signaling"),
  expand.complexes = FALSE,
  inc.sm.molecules = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{biopax}{BioPAX object generated by \code{\link[rBiopaxParser]{readBiopax}}.}

\item{parse.as}{Whether to process file into a metabolic or a signaling network.}

\item{expand.complexes}{Split protein complexes into individual gene nodes. Ignored if
\code{parse.as="metabolic"}.}

\item{inc.sm.molecules}{Include small molecules that are participating in signaling events. Ignored if
\code{parse.as="metabolic"}.}

\item{verbose}{Whether to display the progress of the function.}
}
\value{
An igraph object, representing a metbolic or a signaling network.
}
\description{
This function takes BioPAX objects (level 2 or 3) as input, and returns either a metabolic or a signaling
network as output.
}
\details{
This function requires \code{rBiopaxParser} installed.

Users can specify whether files are processes as metabolic or signaling networks.

Metabolic networks are given as bipartite graphs, where metabolites and reactions represent
vertex types. Reactions are constructed from \code{Conversion} classes, connecting them
to their corresponding \code{Left}s and \code{Right}s. Each reaction vertex has \code{genes} attribute,
listing all \code{Catalysis} relationships of this reaction. As a general rule, reactions inherit all annotation
attributes of its catalyzig genes.

Signaling network have genes as vertices and edges represent interactions, such as activiation / inhibition.
Genes participating in successive reactions are also connected. Signaling interactions are constructed from
\code{Control} classes, where edges are drawn from \code{controller} to \code{controlled}.

All annotation attributes are exracted from \code{XRefs} associated with the vertices, and are stored according to
MIRIAM guidelines (\code{miraim.db}, where db is the database name).
}
\examples{
if(requireNamespace("rBiopaxParser")){
    data(ex_biopax)
    # Process biopax as a metabolic network
    g <- biopax2igraph(ex_biopax)
    plotNetwork(g)

    # Process SBML file as a signaling network
    g <- biopax2igraph(ex_biopax, parse.as="signaling", expand.complexes=TRUE)
}
}
\seealso{
Other Database extraction methods: 
\code{\link{KGML2igraph}()},
\code{\link{SBML2igraph}()}
}
\author{
Ahmed Mohamed
}
\concept{Database extraction methods}
