% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbExtract.R
\name{SBML2igraph}
\alias{SBML2igraph}
\title{Processes SBML files into igraph objects}
\usage{
SBML2igraph(
  filename,
  parse.as = c("metabolic", "signaling"),
  miriam.attr = "all",
  gene.attr,
  expand.complexes,
  verbose = TRUE
)
}
\arguments{
\item{filename}{A character vector containing the SBML files to be processed. If a directory path
is provided, all *.xml and *.sbml files in it and its subdirectories are included.}

\item{parse.as}{Whether to process file into a metabolic or a signaling network.}

\item{miriam.attr}{A list of annotation attributes to be extracted. If \code{"all"}, then all attibutes
written in MIRIAM guidelines (see Details) are extracted (Default). If \code{"none"}, then no attributes
are extracted. Otherwise, only attributes matching those specified are extracted.}

\item{gene.attr}{An attribute to distinguish \code{species} representing genes from those
representing small molecules (see Details). Ignored if \code{parse.as="metabolic"}.}

\item{expand.complexes}{Split protein complexes into individual gene nodes. Ignored if
\code{parse.as="metabolic"}, or when \code{gene.attr} is not provided.}

\item{verbose}{Whether to display the progress of the function.}
}
\value{
An igraph object, representing a metbolic or a signaling network.
}
\description{
This function takes SBML files as input, and returns either a metabolic or a signaling
network as output.
}
\details{
Users can specify whether files are processes as metabolic or signaling networks.

Metabolic networks are given as bipartite graphs, where metabolites and reactions represent
vertex types. This is constructed from \code{ListOfReactions} in SBML file, connecting them
to their corresponding substrates and products (\code{ListOfSpecies}). Each reaction vertex has \code{genes} attribute,
listing all \code{modifiers} of this reaction. As a general rule, reactions inherit all annotation
attributes of its catalyzig genes.

Signaling network have genes as vertices and edges represent interactions. Since SBML format may
represent singling events as \code{reaction}, all species are assumed to be genes (rather than small
molecules). For a simple path \code{S0 -> R1 -> S1}, in signaling network, the path will be
\code{S0 -> M(R1) -> S1} where \code{M(R1)} is R1 modifier(s). To ditiguish gene species from small
molecules, user can provide \code{gene.attr} (for example: \code{miriam.uniprot} or \code{miriam.ncbigene})
where only annotated species are considered genes.

All annotation attributes written according to MIRIAM guidlines (either \code{urn:miriam:xxx:xxx} or
\code{http://identifiers.org/xxx/xxx}) are etxracted by default. Non-conforming attributes can be extracted
by specifying \code{miriam.attr}.

To generate a genome scale network, simply provide a list of files to be parsed, or put all
file in a directory, as pass the directory path as \code{filename}

Note: This function requires libSBML installed (Please see the installation instructions in the Vignette).
Some SBML level-3 files may requires additional libraries also (An infomative error will be displayed when
parsing such files). Please visit \url{http://sbml.org/Documents/Specifications/SBML_Level_3/Packages} for
more information.
}
\examples{
if(is.loaded("readsbmlfile")){ # This is false if libSBML wasn't available at installation.
    filename <- system.file("extdata", "porphyrin.sbml", package="NetPathMiner")

    # Process SBML file as a metabolic network
    g <- SBML2igraph(filename)
    plotNetwork(g)

    # Process SBML file as a signaling network
    g <- SBML2igraph(filename, parse.as="signaling",
                    gene.attr="miriam.uniprot",expand.complexes=TRUE)
    dev.new()
    plotNetwork(g)
}
}
\seealso{
Other Database extraction methods: 
\code{\link{KGML2igraph}()},
\code{\link{biopax2igraph}()}
}
\author{
Ahmed Mohamed
}
\concept{Database extraction methods}
