% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_housekeeping.R
\name{normalize_housekeeping}
\alias{normalize_housekeeping}
\title{Housekeeping gene normalization}
\usage{
normalize_housekeeping(dat, genes = NULL, logfile = "")
}
\arguments{
\item{dat}{NanoString data, including expression matrix and gene dictionary.}

\item{genes}{List of housekeeping genes to use for normalization. If NULL 
(default), will use all genes marked as "Housekeeping" in codeset.}

\item{logfile}{Optional name of logfile to print messages, warnings 
or errors.}
}
\value{
NanoString data, with expression matrix now normalized by 
housekeeping gene expression.
}
\description{
Scale endogenous and housekeeping genes by the geometric mean of 
housekeeping genes. This should be conducted after positive control 
normalization and background correction.  This step is conducted 
within processNanostringData, when normalization is set to "nCounter".
}
\examples{
example_data <- system.file("extdata", "GSE117751_RAW", package = "NanoTube")

# Load data, positive control normalization, and background filtering
dat <- read_merge_rcc(list.files(example_data, full.names = TRUE))
dat <- normalize_pos_controls(dat)
dat <- remove_background(dat, mode = "t.test", pval = 0.05)

# Normalize by genes marked "Housekeeping" in RCC files
dat <- normalize_housekeeping(dat)

# Normalize by specified housekeeping genes (gene symbol or accession)
dat <- normalize_housekeeping(dat,
                       genes = c("TUBB", "TBP", "POLR2A", "GUSB", "SDHA"))
}
