% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pca.R
\name{plot_pca}
\alias{plot_pca}
\title{Plot PCA}
\usage{
plot_pca(
  x,
  plot_dims = c(1, 2),
  labels = colnames(x),
  groups = NULL,
  legend_name = "group"
)
}
\arguments{
\item{x}{a numeric matrix where rows are genomic regions/features and columns
are samples. Should be a log-methylation-ratio matrix for best results.}

\item{plot_dims}{the numeric vector of the two dimensions to be plotted
(default c(1, 2) for PC1 vs PC2).}

\item{labels}{the character vector of labels for data points. By default uses
column names of x, set to NULL to plot unlabeled points.}

\item{groups}{the character vector or numeric vector of groups that data points
will be coloured by. For character vectors, discrete colours are used. For
numeric vectors, continuous colour scale is used. By default, groups is NULL
and points are not coloured.}

\item{legend_name}{the name for the colour legend.}
}
\value{
ggplot object of the PCA plot.
}
\description{
Plot principal component analysis plot using BiocSingular::runPCA(). It is recommended this be done with
the log-methylation-ratio matrix generated by bsseq_to_log_methy_ratio().
}
\details{
Principal Component Analysis (PCA) is a dimensionality reduction technique that
identifies the directions of maximum variance in high-dimensional data. Unlike
MDS, PCA axis labels show the principal component numbers rather than variance
explained percentages. The first principal component (PC1) captures the most
variance in the data, PC2 captures the second most, and so on. Samples that
cluster together have similar methylation profiles across the genomic regions
included in the analysis.
}
\examples{
nmr <- load_example_nanomethresult()
bss <- methy_to_bsseq(nmr)
lmr <- bsseq_to_log_methy_ratio(bss)
plot_pca(lmr)

}
