% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_small_p_val.R
\name{check_small_p_val}
\alias{check_small_p_val}
\title{Ensure that the non-negative p-values are not 5e-324 or lower, if so set to 0}
\source{
\code{
sumstats_dt <- MungeSumstats:::formatted_example()
sumstats_dt$P[1:3] <- 5e-324
sumstats_dt$P[6:10] <- "5e-324"
sumstats <- check_small_p_val(sumstats_dt = sumstats_dt,
                              convert_small_p = TRUE, 
                              imputation_ind = TRUE)
}
}
\usage{
check_small_p_val(sumstats_dt, convert_small_p, imputation_ind)
}
\arguments{
\item{sumstats_dt}{data table obj of the summary statistics file for the GWAS}

\item{convert_small_p}{Binary, should non-negative
p-values <= 5e-324 be converted to 0?
Small p-values pass the R limit and can cause errors with LDSC/MAGMA and
should be converted. Default is TRUE.}

\item{imputation_ind}{Binary Should a column be added for each imputation
step to show what SNPs have imputed values for differing fields. This
includes a field denoting SNP allele flipping (flipped). On the flipped
value, this denoted whether the alelles where switched based on
MungeSumstats initial choice of A1, A2 from the input column headers and thus
may not align with what the creator intended.\strong{Note} these columns will be
in the formatted summary statistics returned. Default is FALSE.}
}
\value{
list containing sumstats_dt,
the modified summary statistics data table object
}
\description{
Ensure that the non-negative p-values are not 5e-324 or lower, if so set to 0
}
\keyword{internal}
