% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_effect_columns_nonzero.R
\name{check_effect_columns_nonzero}
\alias{check_effect_columns_nonzero}
\title{Ensure that the standard error (se) is positive for all SNPs}
\usage{
check_effect_columns_nonzero(
  sumstats_dt,
  path,
  effect_columns_nonzero,
  log_folder_ind,
  check_save_out,
  tabix_index,
  nThread,
  log_files
)
}
\arguments{
\item{path}{Filepath for the summary statistics file to be formatted. A
dataframe or datatable of the summary statistics file can also be passed
directly to MungeSumstats using the path parameter.}

\item{effect_columns_nonzero}{Binary should the effect columns in the data
BETA,OR (odds ratio),LOG_ODDS,SIGNED_SUMSTAT be checked to ensure no SNP=0.
Those that do are removed(if present in sumstats file). Default FALSE.}

\item{log_folder_ind}{Binary Should log files be stored containing all
filtered out SNPs (separate file per filter). The data is outputted in the
same format specified for the resulting sumstats file. The only exception to
this rule is if output is vcf, then log file saved as .tsv.gz. Default is
FALSE.}

\item{tabix_index}{Index the formatted summary statistics with
\href{http://www.htslib.org/doc/tabix.html}{tabix} for fast querying.}

\item{nThread}{Number of threads to use for parallel processes.}

\item{log_files}{list of log file locations}
}
\value{
list containing sumstats_dt, the modified summary statistics data
table object and the log file list
}
\description{
Ensure that the standard error (se) is positive for all SNPs
}
\keyword{internal}
