% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment-methods.R
\name{experiment-methods}
\alias{experiment-methods}
\alias{experiment,MultimodalExperiment-method}
\alias{experiment}
\alias{experiment<-,MultimodalExperiment-method}
\alias{experiment<-}
\alias{bulkExperiments,MultimodalExperiment-method}
\alias{bulkExperiments}
\alias{bulkExperiments<-,MultimodalExperiment-method}
\alias{bulkExperiments<-}
\alias{singleCellExperiments,MultimodalExperiment-method}
\alias{singleCellExperiments}
\alias{singleCellExperiments<-,MultimodalExperiment-method}
\alias{singleCellExperiments<-}
\title{MultimodalExperiment Experiment Methods}
\usage{
\S4method{experiment}{MultimodalExperiment}(x, i)

\S4method{experiment}{MultimodalExperiment}(x, i) <- value

\S4method{bulkExperiments}{MultimodalExperiment}(x)

\S4method{bulkExperiments}{MultimodalExperiment}(x) <- value

\S4method{singleCellExperiments}{MultimodalExperiment}(x)

\S4method{singleCellExperiments}{MultimodalExperiment}(x) <- value
}
\arguments{
\item{x}{a \linkS4class{MultimodalExperiment} object}

\item{i}{an integer or character index}

\item{value}{a replacement value}
}
\value{
\code{experiment} returns a matrix-like object.

\code{bulkExperiments} returns an \link{ExperimentList} of matrix-like objects.

\code{singleCellExperiments} returns an \link{ExperimentList} of matrix-like objects.
}
\description{
Extract or replace experiments of a \linkS4class{MultimodalExperiment} object by
index, name, or type.
}
\details{
The term matrix-like objects refers to \link[base:matrix]{matrix}
objects or Bioconductor S4 objects that contain them (
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment},
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment},
etc.) where rows represent features and columns represent observations.
}
\examples{
ME <-
    MultimodalExperiment()

bulkExperiments(ME) <-
    ExperimentList(
        pbRNAseq = pbRNAseq
    )

singleCellExperiments(ME) <-
    ExperimentList(
        scADTseq = scADTseq,
        scRNAseq = scRNAseq
    )

subjectMap(ME)[["subject"]] <-
    "SUBJECT-1"

sampleMap(ME)[["subject"]] <-
    "SUBJECT-1"

cellMap(ME)[["sample"]] <-
    "SAMPLE-1"

ME <-
    propagate(ME)

experimentData(ME)[["published"]] <-
    c(NA_character_, "2018-11-19", "2018-11-19") |>
    as.Date()

subjectData(ME)[["condition"]] <-
    as.character("healthy")

sampleData(ME)[["sampleType"]] <-
    as.character("peripheral blood mononuclear cells")

cellType <- function(x) {
    if (x[["CD4"]] > 0L) {
        return("T Cell")
    }

    if (x[["CD14"]] > 0L) {
        return("Monocyte")
    }

    if (x[["CD19"]] > 0L) {
        return("B Cell")
    }

    if (x[["CD56"]] > 0L) {
        return("NK Cell")
    }

    NA_character_
}

cellData(ME)[["cellType"]] <-
    experiment(ME, "scADTseq") |>
    apply(2L, cellType)

experiment(ME, 2L) <-
    experiment(ME, 2L)[1:4, 1:4]

experiment(ME, 2L)

experiment(ME, "scRNAseq") <-
    experiment(ME, "scRNAseq")[1:4, 1:4]

experiment(ME, "scRNAseq")

bulkExperiments(ME) <-
    bulkExperiments(ME)[1L]

bulkExperiments(ME)

singleCellExperiments(ME) <-
    singleCellExperiments(ME)[2L]

singleCellExperiments(ME)

}
\seealso{
\code{browseVignettes("MultimodalExperiment")}
}
