% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultimodalExperiment.R
\name{MultimodalExperiment}
\alias{MultimodalExperiment}
\title{MultimodalExperiment Constructor Function}
\usage{
MultimodalExperiment(
    experimentData = DataFrame(),
    subjectData = DataFrame(),
    sampleData = DataFrame(),
    cellData = DataFrame(),
    experimentMap = DataFrame(
        type = character(),
        experiment = character()
    ),
    subjectMap = DataFrame(
        experiment = character(),
        subject = character()
    ),
    sampleMap = DataFrame(
        subject = character(),
        sample = character()
    ),
    cellMap = DataFrame(
        sample = character(),
        cell = character()
    ),
    experiments = ExperimentList(),
    metadata = list()
)
}
\arguments{
\item{experimentData}{a \link[S4Vectors:DataFrame-class]{DataFrame} of experiment
annotations with experiment indices as rownames}

\item{subjectData}{a \link[S4Vectors:DataFrame-class]{DataFrame} of subject
annotations with subject indices as rownames}

\item{sampleData}{a \link[S4Vectors:DataFrame-class]{DataFrame} of sample
annotations with sample indices as rownames}

\item{cellData}{a \link[S4Vectors:DataFrame-class]{DataFrame} of cell annotations
with cell indices as rownames}

\item{experimentMap}{a \link[S4Vectors:DataFrame-class]{DataFrame} of type (bulk
or single-cell) to experiment (index) mappings}

\item{subjectMap}{a \link[S4Vectors:DataFrame-class]{DataFrame} of experiment
(index) to subject (index) mappings}

\item{sampleMap}{a \link[S4Vectors:DataFrame-class]{DataFrame} of subject (index)
to sample (index) mappings}

\item{cellMap}{a \link[S4Vectors:DataFrame-class]{DataFrame} of sample (index) to
cell (index) mappings}

\item{experiments}{an \link{ExperimentList} of matrix-like objects}

\item{metadata}{a \link[base:list]{list} of metadata objects}
}
\value{
\code{MultimodalExperiment} returns a \linkS4class{MultimodalExperiment}
object.
}
\description{
\code{MultimodalExperiment} constructs a \linkS4class{MultimodalExperiment} object.
}
\details{
The term matrix-like objects refers to \link[base:matrix]{matrix}
objects or Bioconductor S4 objects that contain them (
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment},
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment},
etc.) where rows represent features and columns represent observations.
}
\examples{
MultimodalExperiment()

}
\seealso{
\code{browseVignettes("MultimodalExperiment")}
}
