% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEplotBarplotFacetGrid.R
\name{DEplotBarplotFacetGrid}
\alias{DEplotBarplotFacetGrid}
\title{Faceted barplot of specific DE genes}
\usage{
DEplotBarplotFacetGrid(
  Data,
  Abs.col,
  Legend.col,
  Facet.col,
  Value.col,
  Color.Legend = NULL,
  LabsPlot = c("", "")
)
}
\arguments{
\item{Data}{Data.frame containing three or four columns.
One must contain quantitative variable and the other qualitative variables.}

\item{Abs.col}{Integer indicating the column of \code{Data} which will be
used for the x-axis.
The selected column must be one of the qualitative variables and must be
identical to \code{Legend.col} if there are only two qualitative variables.
Otherwise, \code{Abs.col} and \code{Legend.col} must be different.}

\item{Legend.col}{Integer indicating the column of \code{Data} which is used
for the color of the barplots.
The selected column must be one of the qualitative variables and must be
identical to \code{Abs.col} if there are only two qualitative variables.
Otherwise, \code{Abs.col} and \code{Legend.col} must be different.}

\item{Facet.col}{Integer indicating the column of \code{Data} which is used
for separating barplots in different panels, one per level of the
qualitative variable.
The selected column must be one of the qualitative variables.}

\item{Value.col}{Integer indicating the column of \code{Data} which contains
numeric values.}

\item{Color.Legend}{Data.frame or \code{NULL}.
If \code{Color.Legend} is a data.frame, the data.frame must have two columns
and \eqn{N_{bc}} rows where \eqn{N_{bc}} is the number of biological
conditions. The first column must contain the name of the \eqn{N_{bc}}
different biological conditions and the second column must the color
associated to each biological condition.
If \code{Color.Legend=NULL}, the function will automatically attribute
a color for each biological condition.}

\item{LabsPlot}{Vector of two characters indicating the x-axis label and
the y-axis label of the facet grid barplot.
By default, \code{LabsPlot=c("", "")}.}
}
\value{
The function will plot a facet grid barplot.
The function is called by our function
\code{\link[=DEanalysisTimeAndGroup]{DEanalysisTimeAndGroup()}}
in order to plot the number of specific (up- or down-regulated) DE genes
per biological condition for each time points.
}
\description{
The function creates a faceted barplot from a data.frame
containing two or three qualitative variables and one quantitative variable.
}
\examples{
Group.ex <- c('G1', 'G2', 'G3')
Time.ex <- c('t1', 't2', 't3', 't4')
Spe.sign.ex <- c("Pos", "Neg")
GtimesT <- length(Group.ex)*length(Time.ex)

Nb.Spe <- sample(3:60, GtimesT, replace=FALSE)
Nb.Spe.sign <- sample(3:60, 2*GtimesT, replace=FALSE)

##------------------------------------------------------------------------##
Melt.Dat.1 <- data.frame(Group=rep(Group.ex, times=length(Time.ex)),
                         Time=rep(Time.ex, each=length(Group.ex)),
                         Nb.Spe.DE=Nb.Spe)

DEplotBarplotFacetGrid(Data=Melt.Dat.1, Abs.col=2, Legend.col=2,
                       Facet.col=1, Value.col=3, Color.Legend=NULL)
DEplotBarplotFacetGrid(Data=Melt.Dat.1, Abs.col=1, Legend.col=1,
                       Facet.col=2, Value.col=3, Color.Legend=NULL)
##------------------------------------------------------------------------##
Melt.Dat.2 <- data.frame(Group=rep(Group.ex, times=length(Time.ex)*2),
                         Time=rep(Time.ex, each=length(Group.ex)*2),
                         Spe.sign=rep(Spe.sign.ex, times=2*GtimesT),
                         Nb.Spe.DE=Nb.Spe.sign)
Melt.Dat.2 <- stats::aggregate(Nb.Spe.DE~., data=Melt.Dat.2, sum)

DEplotBarplotFacetGrid(Data=Melt.Dat.2,
                       Abs.col=1,
                       Legend.col=3,
                       Facet.col=2,
                       Value.col=4,
                       Color.Legend=NULL)
}
\seealso{
The function
\itemize{
\item is called by the function
\code{\link[=DEanalysisTimeAndGroup]{DEanalysisTimeAndGroup()}}
\item calls the R functions
\code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} and
\code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}.
}
}
