% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEanalysisGlobal.R
\name{DEanalysisGlobal}
\alias{DEanalysisGlobal}
\title{Realization of the DE analysis (Main Function).}
\usage{
DEanalysisGlobal(
  SEres,
  pval.min = 0.05,
  pval.vect.t = NULL,
  log.FC.min = 1,
  LRT.supp.info = FALSE,
  Plot.DE.graph = TRUE,
  path.result = NULL,
  Name.folder.DE = NULL
)
}
\arguments{
\item{SEres}{Results of either our R function
\code{\link[=DATAprepSE]{DATAprepSE()}},
or our R function
\code{\link[=DATAnormalization]{DATAnormalization()}}.}

\item{pval.min}{Numeric value between 0 and 1. A gene will be considered as
differentially expressed (DE) between two biological conditions if
its Benjamini-Hochberg adjusted p-value
(see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the threshold \code{pval.min}. Default value is 0.05.}

\item{pval.vect.t}{\code{NULL} or vector of dimension \eqn{T-1} filled with
numeric values between 0 and 1, with \eqn{T} the number of
time measurements.
A gene will be considered as differentially expressed (DE) between
the time ti and the reference time t0 if its Benjamini-Hochberg adjusted
p-value (see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the i-th threshold of \code{pval.vect.t}.
If \code{NULL}, \code{pval.vect.t} will be vector of dimension \eqn{T-1}
filled with \code{pval.min}.}

\item{log.FC.min}{Non negative numeric value.
If the \eqn{log_2} fold change between biological conditions or times
has an absolute value below the threshold \code{log.FC.min},
then the gene is not selected even if is considered as DE.
Default value is 1.
If \code{log.FC.min=0}, all DE genes will be kept.}

\item{LRT.supp.info}{\code{TRUE} or \code{FALSE}.
If \code{TRUE}, the algorithm realizes another statistical test in order to
detect if, among all biological conditions and/or times,
at least one has a different behavior than the others
(see the input \code{test} in \code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}).}

\item{Plot.DE.graph}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, all graphs will be plotted.
Otherwise no graph will be plotted.}

\item{path.result}{Character or \code{NULL}. Path to save all results.
If \code{path.result} contains a sub folder entitled
"DEanalysis_\code{Name.folder.DE}" all results will be saved in
the sub folder "DEanalysis_\code{Name.folder.DE}".
Otherwise, a sub folder entitled "DEanalysis_\code{Name.folder.DE}"
will be created in \code{path.result} and all results will be saved in
"DEanalysis_\code{Name.folder.DE}".
If \code{NULL}, the results will not be saved in a folder.
\code{NULL} as default.}

\item{Name.folder.DE}{Character or \code{NULL}.
If \code{Name.folder.DE} is a character, the folder names which will
contain all results will be "DEanalysis_\code{Name.folder.DE}".
Otherwise, the folder name will be "DEanalysis".}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEres} with the rle normalized count data (cf \code{\link[=DATAnormalization]{DATAnormalization()}})
automatically realized by
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}
and saved in \code{assays(SEresNORM)$rle}, and with the following results
saved in the metadata \code{Results[[2]][[2]]} of \code{SEres},
depending on the experimental design.
\itemize{
\item If samples belong to different biological conditions only
(see \code{\link[=DEanalysisGroup]{DEanalysisGroup()}}),
the function returns
\itemize{
\item a data.frame (output \code{rowData(SEres)}) which contains
\itemize{
\item pvalues, log2 fold change and DE genes between each pairs of
biological conditions.
\item a binary column (1 and 0) where 1 means the gene is DE between
at least one pair of biological conditions.
\item \eqn{N_{bc}} binary columns,
where \eqn{N_{bc}} is the number of biological conditions,
which gives the specific genes for each biological condition.
A '1' in one of these columns means the gene is specific to
the biological condition associated to the given column. 0 otherwise.
A gene is called specific to a given biological condition BC1,
if the gene is DE between BC1 and any other biological conditions,
but not DE between any pair of other biological conditions.
\item \eqn{N_{bc}} columns filled with -1, 0 and 1, one per biological
condition.
A '1' in one of these columns means the gene is up-regulated
(or over-expressed) for the biological condition associated to the
given column.
A gene is called up-regulated for a given biological condition BC1 if
the gene is specific to the biological condition BC1 and expressions
in BC1 are higher than in the other biological conditions.
A '-1' in one of these columns means the gene is down-regulated
(or under-expressed) for the biological condition associated to the
given column.
A gene is called down-regulated for a given biological condition BC1 if
the gene is specific to the biological condition BC1 and expressions
in BC1 are lower than in the other biological conditions.
A '0' in one of these columns means the gene is not specific to the
biological condition associated to the given column.
}
\item an UpSet plot (Venn diagram displayed as a barplot) which gives the
number of genes for each possible intersection
(see \code{\link[=DEplotVennBarplotGroup]{DEplotVennBarplotGroup()}}).
We consider that a set of pairs of biological conditions forms an
intersection if there is at least one gene which is DE for each of these
pairs of biological conditions, but not for the others.
\item a barplot which gives the number of genes categorized as "Upregulated"
and "DownRugulated", per biological condition
(see \code{\link[=DEplotBarplot]{DEplotBarplot()}}).
\item a barplot which gives the number of genes categorized as "Upregulated",
"DownRugulated" and "Other", per biological condition
(see \code{\link[=DEplotBarplot]{DEplotBarplot()}}).
A gene is categorized as 'Other', for a given biological condition,
if the gene is not specific to the given biological condition.
So this barplot, only plotted when there are strictly more than two
biological conditions, is similar to the previous barplot but with
the category "Other".
\item a list (output \code{List.Glossary}) containing the glossary of
the column names of \code{DE.results}.
\item a list (output \code{Summary.Inputs}) containing a summary of sample
information and inputs of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
}
\item If data belong to different time points only
(see \code{\link[=DEanalysisTime]{DEanalysisTime()}}),
the function returns
\itemize{
\item a data.frame (output \code{rowData(SEres)}) which contains
\itemize{
\item gene names
\item pvalues, log2 fold change and DE genes between each time ti versus
the reference time t0.
\item a binary column (1 and 0) where 1 means the gene is DE at at least
between one time ti versus the reference time t0.
\item a column where each element is succession of 0 and 1.
The positions of '1' indicate the set of times ti such that the gene
is DE between ti and the reference time t0.
}
\item an alluvial graph of differentially expressed (DE) genes
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}})
\item a graph showing the number of DE genes as a function of time for
each temporal group
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}}).
By temporal group, we mean the sets of genes which are first DE at
the same time.
\item a barplot which gives the number of DE genes per time
(see \code{\link[=DEplotBarplotTime]{DEplotBarplotTime()}})
\item an UpSet plot which gives the number of genes per temporal pattern
(see \code{\link[=DEplotVennBarplotTime]{DEplotVennBarplotTime()}}).
By temporal pattern, we mean the set of times ti such that the gene is
DE between ti and the reference time t0.
\item a similar UpSet plot where each bar is split in different colors
corresponding to all possible numbers of DE times where genes are over
expressed in a given temporal pattern.
\item a list (output \code{List.Glossary}) containing the glossary of
the column names of \code{DE.results}.
\item a list (output \code{Summary.Inputs}) containing a summary of sample
information and inputs of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
}
\item If data belong to different time points and different biological
conditions
(see \code{\link[=DEanalysisTimeAndGroup]{DEanalysisTimeAndGroup()}}),
the function returns
\itemize{
\item a data.frame (output \code{rowData(SEres)}) which contains
\itemize{
\item gene names
\item Results from the temporal statistical analysis
\itemize{
\item pvalues, log2 fold change and DE genes between each pairs of
biological conditions for each fixed time.
\item \eqn{N_{bc}} binary columns (0 and 1), one per biological condition
(with \eqn{N_{bc}} the number of biological conditions).
A 1 in one of these two columns means the gene is DE at least between
one time ti versus the reference time t0, for the biological condition
associated to the given column.
\item \eqn{N_{bc}} columns, one per biological condition, where each
element is succession of 0 and 1. The positions of 1 in one of these
two columns, indicate the set of times ti such that the gene is DE
between ti and the reference time t0, for the biological condition
associated to the given column.
}
\item Results from the statistical analysis by biological condition
\itemize{
\item pvalues, log2 fold change and DE genes between each time ti
and the reference time t0 for each biological condition.
\item \eqn{T} binary columns (0 and 1), one per time
(with \eqn{T} the number of time measurements).
A 1 in one of these columns, means the gene is DE between at least
one pair of biological conditions, for the fixed time associated
to the given column.
\item \eqn{T \times N_{bc}} binary columns, which give the genes specific
for each biological condition at each time ti.
A 1 in one of these columns means the gene is specific to the
biological condition at a fixed time associated to the given column.
0 otherwise. A gene is called specific to a given biological condition
BC1 at a time ti, if the gene is DE between BC1 and any other
biological conditions at time ti, but not DE between any pair of
other biological conditions at time ti.
\item \eqn{T \times N_{bc}} columns filled with -1, 0 and 1.
A 1 in one of these columns means the gene is up-regulated
(or over-expressed) for the biological condition at a fixed time
associated to the given column. A gene is called up-regulated for a
given biological condition BC1 at time ti if the gene is specific to
the biological condition BC1 at time ti and expressions in BC1 at time
ti are higher than in the other biological conditions at time ti.
A -1 in one of these columns means the gene is down-regulated
(or under-expressed) for the biological condition at a fixed time
associated to the given column. A gene is called down-regulated for a
given biological condition at a time ti BC1 if the gene is specific to
the biological condition BC1 at time ti and expressions in BC1 at time
ti are lower than in the other biological conditions at time ti.
A 0 in one of these columns means the gene is not specific to the
biological condition at a fixed time associated to the given column.
\item \eqn{N_{bc}} binary columns (0 and 1). A 1 in one of these columns
means the gene is specific at at least one time ti, for the biological
condition associated to the given column. 0 otherwise.
}
\item Results from the combination of temporal and biological statistical
analysis
\itemize{
\item \eqn{T \times N_{bc}} binary columns, which give the signatures
genes for each biological condition at each time ti.
A 1 in one of these columns means the gene is signature gene to the
biological condition at a fixed time associated to the given column.
0 otherwise. A gene is called signature of a biological condition
BC1 at a given time ti, if the gene is specific to the biological
condition BC1 at time ti and DE between ti versus the reference time
t0 for the biological condition BC1.
\item \eqn{N_{bc}} binary columns (0 and 1). A 1 in one of these columns
means the gene is signature at at least one time ti, for the
biological condition associated to the given column. 0 otherwise.
}
}
\item the following plots from the temporal statistical analysis
\itemize{
\item a barplot which gives the number of DE genes between ti and the
reference time t0, for each time ti (except the reference time t0) and
biological condition
(see \code{\link[=DEplotBarplotFacetGrid]{DEplotBarplotFacetGrid()}}).
\item \eqn{N_{bc}} alluvial graphs of DE genes
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}}),
one per biological condition.
\item \eqn{N_{bc}} graphs showing the number of DE genes as a function of
time for each temporal group, one per biological condition.
By temporal group, we mean the sets of genes which are first DE at the
same time.
\item \eqn{2\times N_{bc}} UpSet plot showing the number of DE genes
belonging to each DE temporal pattern, for each biological condition.
By temporal pattern, we mean the set of times ti such that the gene is
DE between ti and the reference time t0
(see \code{\link[=DEplotVennBarplotTime]{DEplotVennBarplotTime()}}).
\item an alluvial graph for DE genes which are DE at least one time for
each group.
}
\item the following plots from the statistical analysis by biological
condition
\itemize{
\item a barplot which gives the number of specific DE genes for each
biological condition and time
(see \code{\link[=DEplotBarplotFacetGrid]{DEplotBarplotFacetGrid()}}).
\item \eqn{N_{bc}(N_{bc}-1)/2} UpSet plot which give the number of genes
for each possible intersection (set of pairs of biological conditions),
one per time
(see \code{\link[=DEplotVennBarplotGroup]{DEplotVennBarplotGroup()}}).
\item an alluvial graph of genes which are specific at least one time
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}}).
}
\item the following plots from the combination of temporal and biological
statistical analysis
\itemize{
\item a barplot which gives the number of signature genes for each
biological condition and time
(see \code{\link[=DEplotBarplotFacetGrid]{DEplotBarplotFacetGrid()}}).
\item a barplot showing the number of genes which are DE at at least one
time, specific at at least one time and signature at at least one time,
for each biological condition.
\item an alluvial graph of genes which are signature at least one time
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}}).
}
}
}
}
\description{
The function realizes the DE analysis in three cases:
either samples belonging to different time measurements,
or samples belonging to different biological conditions,
or samples belonging to different time measurements
and different biological conditions.
}
\details{
All results are built from the results of either our R function
\code{\link[=DATAprepSE]{DATAprepSE()}},
or our R function
\code{\link[=DATAnormalization]{DATAnormalization()}}.
}
\examples{
data(RawCounts_Antoszewski2022_MOUSEsub500)
## No time points. We take only two groups for the speed of the example
RawCounts_T1Wt <- RawCounts_Antoszewski2022_MOUSEsub500[seq_len(200),
                                                        seq_len(7)]
##------------------------------------------------------------------------##
## Preprocessing
resDATAprepSE <- DATAprepSE(RawCounts=RawCounts_T1Wt,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=NULL,
                            Individual.position=2)
##------------------------------------------------------------------------##
## DE analysis
resDE <- DEanalysisGlobal(SEres=resDATAprepSE,
                          pval.min=0.05,
                          pval.vect.t=NULL,
                          log.FC.min=1,
                          LRT.supp.info=FALSE,
                          Plot.DE.graph=TRUE,
                          path.result=NULL,
                          Name.folder.DE=NULL)
}
