% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{add_rse}
\alias{add_rse}
\title{Method to add a \code{RangedSummarizedExperiment} to \code{MultiDataSet}.}
\usage{
add_rse(
  object,
  set,
  dataset.type,
  dataset.name = NULL,
  sample.tables = NULL,
  feature.tables = NULL,
  warnings = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filled.}

\item{set}{Object derived from \code{RangedSummarizedExperiment} to be used to fill the slot.}

\item{dataset.type}{Character with the type of data of the omic set (e.g. expression, methylation...)}

\item{dataset.name}{Character with the specific name for this set (NULL by default). It is useful when there 
are several sets of the same type (e.g. multiple expression assays)}

\item{sample.tables}{Character with the names of the slots with sample data besides colData.}

\item{feature.tables}{Character with the names of the slots with feature data besides rowData.}

\item{warnings}{Logical to indicate if warnings will be displayed.}

\item{overwrite}{Logical to indicate if the set stored in the slot will be overwritten.}
}
\value{
A new \code{MultiDataSet} with a slot filled.
}
\description{
This method adds or overwrites a slot of a \code{MultiDataSet} with the content 
of the given  \code{RangedSummarizedExperiment}.
}
\examples{
if (require(GenomicRanges) & require(SummarizedExperiment)){
multi <- createMultiDataSet()
counts <- matrix(runif(200 * 6, 1, 1e4), 200)
rowRanges <- GRanges(rep(c("chr1", "chr2"), c(50, 150)),
                     IRanges(floor(runif(200, 1e5, 1e6)), width=100),
                     strand=sample(c("+", "-"), 200, TRUE),
                     feature_id=sprintf("ID\%03d", 1:200))
colData <- DataFrame(Treatment=rep(c("ChIP", "Input"), 3),
                    row.names=LETTERS[1:6], id = LETTERS[1:6])
names(rowRanges) <- 1:200
rse <- SummarizedExperiment(assays=SimpleList(counts=counts),
                            rowRanges=rowRanges, colData=colData)
multi <- add_rse(multi, rse, "rseEx")
}
}
