% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{Q2_plot}
\alias{Q2_plot}
\title{Q2_plot}
\usage{
Q2_plot(mbac, ...)
}
\arguments{
\item{mbac}{Object of class mbac generated by *MultiBaC* or *genModelList*.}

\item{...}{Other graphical parameters}
}
\value{
Q2 plot of PLS models is displayed.
}
\description{
Q2_plot
}
\examples{
data('multiyeast')

my_mbac <- createMbac (inputOmics = list(A.rna, A.gro, B.rna, B.ribo, C.rna, C.par),
                       batchFactor = c("A", "A", "B", "B", "C", "C"),
                       experimentalDesign = list("A" =  c("Glu+", "Glu+",
                       "Glu+", "Glu-", "Glu-", "Glu-"),
                       "B" = c("Glu+", "Glu+", "Glu-", "Glu-"),
                       "C" = c("Glu+", "Glu+", "Glu-", "Glu-")),
                       omicNames = c("RNA", "GRO", "RNA", "RIBO", "RNA", "PAR"))

my_final_mbac <- MultiBaC (my_mbac,
                           test.comp = NULL, scale = FALSE,
                           center = TRUE, crossval = NULL,
                           Variability = 0.90,
                           Interaction = TRUE ,
                           showplot = FALSE,
                           showinfo = FALSE)

Q2_plot (my_final_mbac)

}
