% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepMultiAssay.R
\name{prepMultiAssay}
\alias{prepMultiAssay}
\title{Prepare a \code{MultiAssayExperiment} instance}
\usage{
prepMultiAssay(ExperimentList, colData, sampleMap, ...)
}
\arguments{
\item{ExperimentList}{A \code{list} of all combined experiments}

\item{colData}{A \code{\link[S4Vectors:DataFrame-class]{DataFrame}} of the phenotype
data for all participants}

\item{sampleMap}{A \code{\link[S4Vectors:DataFrame-class]{DataFrame}} of sample
identifiers, assay samples, and assay names}

\item{...}{Optional arguments for the \code{MultiAssayExperiment} constructor
function such as \code{metadata} and \code{drops}.}
}
\value{
A \code{list} containing all the essential components of a
\code{\link{MultiAssayExperiment}} as well as a "drops" metadata element that
indicates non-matched names. The names of the resulting list correspond to
the arguments of the \code{MultiAssayExperiment} constructor function.
}
\description{
The purpose of this helper function is to faciltate the creation of a
\code{\link{MultiAssayExperiment}} object by detecting any inconsistencies
with all types of names in either the \code{\link{ExperimentList}},
the \code{colData}, or \code{\link{sampleMap}}.
}
\section{Checks}{

The \code{prepMultiAssay} function checks that all columns in the sampleMap
are \code{character}.

It checks that all names and lengths match in both the
\code{\link{ExperimentList}} and in the unique assay names of the
\code{\link{sampleMap}}.

If \code{\link{ExperimentList}} names and assay names only differ by case
and are not duplicated, the function will standardize all names to
lowercase.

If names cannot be matched between the colname column of the
\code{\link{sampleMap}} and the colnames of the \code{ExperimentList}, those
unmatched will be dropped and found in the "drops" element of the
resulting \code{list}.

Names in the "primary" column of the \code{\link{sampleMap}}, will be
matched to those in the \code{colData}. Unmatched "primary" column rows will
be dropped from the \code{\link{sampleMap}}. Suggestions for name fixes in
either the \code{\link{ExperimentList}} or colnames will be made when
necessary.
}

\examples{
## Run example
example("MultiAssayExperiment")

## Check if there are any inconsistencies within the different names
preparedMAE <- prepMultiAssay(ExpList, colDat, sampMap)

## Results in a list of components for the MultiAssayExperiment constructor
## function
MultiAssayExperiment(preparedMAE$experiments, preparedMAE$colData,
preparedMAE$sampleMap)

## Alternatively, use the do.call function
do.call(MultiAssayExperiment, preparedMAE)

}
