% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiAssayExperiment-class.R
\name{MultiAssayExperiment}
\alias{MultiAssayExperiment}
\title{Construct an integrative representation of multi-omic data with
\code{MultiAssayExperiment}}
\usage{
MultiAssayExperiment(
  experiments = ExperimentList(),
  colData = S4Vectors::DataFrame(),
  sampleMap = S4Vectors::DataFrame(assay = factor(), primary = character(), colname =
    character()),
  metadata = list(),
  drops = list()
)
}
\arguments{
\item{experiments}{A \code{list} or \code{\link{ExperimentList}} of all
combined experiments}

\item{colData}{A \code{\link[S4Vectors:DataFrame-class]{DataFrame}} or
\code{data.frame} of characteristics for all biological units}

\item{sampleMap}{A \code{\link[S4Vectors:DataFrame-class]{DataFrame}} or
\code{data.frame} of assay names, sample identifiers, and colname samples}

\item{metadata}{An optional argument of "ANY" class (usually list) for
content describing the experiments}

\item{drops}{A \code{list} of unmatched information
(included after subsetting)}
}
\value{
A \code{MultiAssayExperiment} object that can store
experiment and phenotype data
}
\description{
The constructor function for the \linkS4class{MultiAssayExperiment} combines
multiple data elements from the different hierarchies of data
(study, experiments, and samples). It can create instances where neither
a \code{sampleMap} or a \code{colData} set is provided. Please see the
MultiAssayExperiment API documentation for more information.
}
\section{colData}{

The \code{colData} input can be either \code{DataFrame} or \code{data.frame} with
subsequent coercion to DataFrame. The rownames in the \code{colData} must match
the colnames in the experiments if no sampleMap is provided.
}

\section{experiments}{

The \code{experiments} input can be of class
\code{\link[S4Vectors:SimpleList-class]{SimpleList}} or \code{list}. This input becomes the
\code{\link{ExperimentList}}. Each element of the input \code{list} or \code{List} must be named,
rectangular with two dimensions, and have \code{dimnames}.
}

\section{sampleMap}{

The \code{\link{sampleMap}} can either be input as \code{DataFrame} or
\code{data.frame} with eventual coercion to \code{DataFrame}. The \code{sampleMap} relates
biological units and biological measurements within each assay. Each row in
the \code{sampleMap} is a single such link. The standard column names of the
\code{sampleMap} are "assay", "primary", and "colname".  Note that the "assay"
column is a factor corresponding to the names of each experiment in the
\code{ExperimentList}. In the case where these names do not match between the
\code{sampleMap} and the experiments, the documented experiments in the
\code{sampleMap} take precedence and experiments are dropped by the harmonization
procedure. The constructor function will generate a \code{sampleMap} in the case
where it is not provided and this method may be a 'safer' alternative for
creating the \code{MultiAssayExperiment} (so long as the rownames are identical
in the \code{colData}, if provided).  An empty \code{sampleMap} may produce empty
experiments if the levels of the "assay" factor in the \code{sampleMap} do not
match the names in the \code{ExperimentList}.
}

\examples{
## Run the example ExperimentList
example("ExperimentList")

## Create sample maps for each experiment
exprmap <- data.frame(
    primary = c("Jack", "Jill", "Barbara", "Bob"),
    colname = c("array1", "array2", "array3", "array4"),
    stringsAsFactors = FALSE)

methylmap <- data.frame(
    primary = c("Jack", "Jack", "Jill", "Barbara", "Bob"),
    colname = c("methyl1", "methyl2", "methyl3", "methyl4", "methyl5"),
    stringsAsFactors = FALSE)

rnamap <- data.frame(
    primary = c("Jack", "Jill", "Bob", "Barbara"),
    colname = c("samparray1", "samparray2", "samparray3", "samparray4"),
    stringsAsFactors = FALSE)

gistmap <- data.frame(
    primary = c("Jack", "Bob", "Jill"),
    colname = c("samp0", "samp1", "samp2"),
    stringsAsFactors = FALSE)

## Combine as a named list and convert to a DataFrame
maplist <- list(Affy = exprmap, Methyl450k = methylmap,
    RNASeqGene = rnamap, GISTIC = gistmap)

## Create a sampleMap
sampMap <- listToMap(maplist)
## Create an example phenotype data
colDat <- data.frame(sex = c("M", "F", "M", "F"), age = 38:41,
    row.names = c("Jack", "Jill", "Bob", "Barbara"))

## Create a MultiAssayExperiment instance
mae <- MultiAssayExperiment(experiments = ExpList, colData = colDat,
    sampleMap = sampMap)
}
\seealso{
\linkS4class{MultiAssayExperiment}
}
