% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{chromatographyDuration}
\alias{chromatographyDuration}
\title{chromatography duration (MS:4000053)}
\usage{
chromatographyDuration(spectra, ...)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{...}{not used here}
}
\value{
\code{numeric(1)}
}
\description{
MS:4000053
"The retention time duration of the chromatography in seconds." [PSI:MS] \cr 

The metric is calculated as follows: \cr 
(1) the retention time associated to the \code{Spectra} object is obtained, \cr  
(2) the maximum and the minimum of the retention time is obtained, \cr  
(3) the difference between the maximum and the minimum is calculated and 
returned. \cr
}
\details{
MS:4000053
synonym: "RT-Duration" RELATED [PMID:24494671] \cr
is_a: MS:4000003 ! single value \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000016 ! retention time metric \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV term \cr
relationship: has_value_concept NCIT:C25330 ! Duration \cr
relationship: has_units UO:0000010 ! second \cr

Retention time values that are \code{NA} are removed.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$rtime <- c(9.44, 9.44, 15.84)
sps <- Spectra(spd)
chromatographyDuration(spectra = sps)
}
\author{
Thomas Naake
}
