% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_utils.R
\name{common_path}
\alias{common_path}
\title{Extract the common file path}
\usage{
common_path(x, fsep = .Platform$file.sep)
}
\arguments{
\item{x}{\code{character} with the \strong{file names} (including paths).}

\item{fsep}{\code{character(1)} defining the file separator to be used in
the returned common path. Defaults to the system platform's file
separator.}
}
\value{
\code{character(1)} representing the path common to all files in \code{x}.
}
\description{
Find the common part of the path up to a provided set of files. Be aware that
the last element (after the last file separator) is treated as a \emph{file}.
Thus, if only directories, without files are submitted, the common path
containing these directories is returned.
}
\note{
This function uses \code{"(\\\\\\\\)|/"} to split the provided paths into the
individual directories to support both Windows-specific and
unix-specific separators between folders. File and folder names
should thus \strong{not} contain these characters.
}
\examples{

## Find the common part of the file path
pths <- c("/tmp/some/dir/a.txt", "/tmp/some/dir/b.txt",
    "/tmp/some/other/dir/c.txt", "/tmp/some/other/dir/d.txt")

common_path(pths)

## If there is no common part
common_path(c("/a/b", "b"))

## Windows paths; note that "/" is used as file separator in the result
common_path(c("C:\\\\some\\\\path\\\\a.txt", "C:\\\\some\\\\path\\\\b.txt"))

## No input
common_path(character())

## No path
common_path(c("a.txt", "b.txt"))

## Same path for all
common_path(c("a/a.txt", "a/a.txt"))
}
\author{
Johannes Rainer
}
