% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retry_download.R
\name{retry}
\alias{retry}
\title{Retry expression on failure}
\usage{
retry(expr, ntimes = 5L, sleep_mult = 0L)
}
\arguments{
\item{expr}{Expression to be evaluated.}

\item{ntimes}{\code{integer(1)} with the number of times to try.}

\item{sleep_mult}{\code{numeric(1)} multiplier to define the increasing waiting
time (in seconds).}
}
\description{
\code{retry()} retries, upon failure, the evaluation of an expression \code{exp} for
\code{ntimes} times waiting an increasing amount of time
between tries, i.e., waiting for \code{Sys.sleep(i * sleep_mult)} seconds between
each try \code{i}. If \code{expr} fails for \code{ntimes} times an error will be thrown.
}
\note{
Warnings are suppressed.
}
\author{
Johannes Rainer
}
