% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackendMassbank.R
\name{MsBackendMassbank}
\alias{MsBackendMassbank}
\alias{MsBackendMassbank-class}
\alias{backendInitialize,MsBackendMassbank-method}
\alias{spectraVariableMapping,MsBackendMassbank-method}
\alias{export,MsBackendMassbank-method}
\title{MS data backend for mgf files}
\usage{
\S4method{backendInitialize}{MsBackendMassbank}(
  object,
  files,
  metaBlocks = metaDataBlocks(),
  nonStop = FALSE,
  ...,
  BPPARAM = bpparam()
)

MsBackendMassbank()

\S4method{spectraVariableMapping}{MsBackendMassbank}(object, format = c("Massbank"))

\S4method{export}{MsBackendMassbank}(
  object,
  x,
  file = tempfile(),
  mapping = spectraVariableMapping(MsBackendMassbank()),
  ...
)
}
\arguments{
\item{object}{Instance of \code{MsBackendMassbank} class.}

\item{files}{\code{character} with the (full) file name(s) of the MassBank file(s)
from which MS/MS data should be imported.}

\item{metaBlocks}{\code{data.frame} indicating which metadata shall
be imported. Default is \code{\link[=metaDataBlocks]{metaDataBlocks()}}.}

\item{nonStop}{\code{logical(1)} whether import should be stopped if an
xml file does not contain all required fields. Defaults to
\code{nonStop = FALSE}.}

\item{...}{Currently ignored.}

\item{BPPARAM}{Parameter object defining the parallel processing
setup to import data in parallel. Defaults to \code{BPPARAM = bpparam()}. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for more information.}

\item{format}{for \code{spectraVariableMapping}: \code{character(1)} defining the
format to be used. Currently only \code{format = "Massbank"} is supported.}

\item{x}{\code{\link[Spectra:Spectra]{Spectra::Spectra()}} object that should be exported.}

\item{file}{for \code{export}: \code{character(1)} defining the output file.}

\item{mapping}{for \code{export}: named \code{character} vector
allowing to specify how fields from the Massbank file should be renamed.
Names are supposed to be the spectra variable name and values of the
vector the field names in the Massbank file. See output of
\code{spectraVariableMapping(MsBackendMassbank())} for the expected format.}
}
\value{
\code{backendInitialize} and \code{MsBackendMassbank} return an instance of
\code{MsBackendMassbank-class}.
}
\description{
The \code{MsBackendMassbank} class supports import of MS/MS spectra data from
MS/MS spectrum data from
\href{https://github.com/MassBank/MassBank-data}{Massbank}
files. After initial import, the full MS data is kept in
memory. \code{MsBackendMassbank} extends the
\code{\link[Spectra:MsBackend]{Spectra::MsBackendDataFrame()}} backend
directly and supports thus the \code{\link[Spectra:addProcessing]{Spectra::applyProcessing()}} function to make
data manipulations persistent.

New objects are created with the \code{MsBackendMassbank} function. The
\code{backendInitialize} method has to be subsequently called to
initialize the object and import MS/MS data from (one or more) MassBank
files. Optional parameter \code{nonStop} allows to specify whether the
import returns with an error if one of the text files lacks required
data, such as \code{mz} and \code{intensity} values (default \code{nonStop = FALSE}), or whether only affected file(s) is(are) skipped and a
warning is shown (\code{nonStop = TRUE}). Note that any other error
will abort import regardless of parameter \code{nonStop}.
}
\examples{

## Create an MsBackendMassbank backend and import data from a test file.
fls <- dir(system.file("extdata", package = "MsBackendMassbank"),
    full.names = TRUE, pattern = "txt$")
be <- backendInitialize(MsBackendMassbank(), fls)
be

be$msLevel
be$intensity
be$mz

## Initializing a backend reading additional metadata columns/information
mb <- metaDataBlocks()
mb
mb[1, 2] <- TRUE

be <- backendInitialize(MsBackendMassbank(), fls, metaBlocks = mb)
spectraVariables(be)
be$instrument
}
\author{
Michael Witting
}
