% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_peak_file.R
\name{read_peak_file}
\alias{read_peak_file}
\title{Read MACS2/3 narrowPeak or SEACR BED peak file}
\usage{
read_peak_file(peak_file, file_format = "auto", verbose = FALSE)
}
\arguments{
\item{peak_file}{A character string with the path to the peak file, or a
GRanges object created using \code{\link[=read_peak_file]{read_peak_file()}}.}

\item{file_format}{A character string specifying the format of the peak file.
\itemize{
 \item \code{"narrowpeak"}: MACS2/3 narrowPeak format.
 \item \code{"bed"}: SEACR BED format.
 }}

\item{verbose}{A logical indicating whether to print messages.}
}
\value{
A \link[GenomicRanges]{GRanges-class} object with the peak
coordinates and summit.
}
\description{
This function reads a MACS2/3 narrowPeak or SEACR BED peak file and
returns a GRanges object with the peak coordinates and summit.
}
\details{
The \emph{summit} column is the absolute genomic position of the peak,
which is relative to the start position of the sequence range.
For SEACR BED files, the \emph{summit} column is calculated as the
midpoint of the max signal region.
}
\examples{
macs3_peak_file <- system.file("extdata", "CTCF_ChIP_peaks.narrowPeak",
package = "MotifPeeker")
macs3_peak_read <- read_peak_file(macs3_peak_file)
macs3_peak_read

}
\seealso{
\link[GenomicRanges]{GRanges-class} for more information on GRanges
objects.
}
