% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpapply.R
\name{bpapply}
\alias{bpapply}
\title{Use BiocParallel functions with appropriate parameters}
\usage{
bpapply(
  X,
  FUN,
  apply_fun = BiocParallel::bplapply,
  BPPARAM = BiocParallel::bpparam(),
  progressbar = FALSE,
  force_snowparam = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{
    Any object for which methods \code{length}, \code{[}, and
    \code{[[} are implemented.
  }

\item{FUN}{
    The \code{function} to be applied to each element of \code{X}.
  }

\item{apply_fun}{A \code{\link[BiocParallel]{BiocParallel}} function to use
for parallel processing. (default = \code{BiocParallel::bplapply})}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam-class}} object
specifying run parameters. (default = bpparam())}

\item{...}{
  Arguments passed on to \code{\link[BiocParallel:bplapply]{BiocParallel::bplapply}}, \code{\link[BiocParallel:bpmapply]{BiocParallel::bpmapply}}
  \describe{
    \item{\code{BPREDO}}{A \code{list} of output from \code{bplapply} with one or
    more failed elements. When a list is given in \code{BPREDO},
    \code{bpok} is used to identify errors, tasks are rerun and inserted
    into the original results.
  }
    \item{\code{BPOPTIONS}}{
    Additional options to control the behavior of the parallel evaluation, see \code{\link[BiocParallel]{bpoptions}}.
  }
    \item{\code{MoreArgs}}{List of additional arguments to \code{FUN}.
  }
    \item{\code{SIMPLIFY}}{
    If \code{TRUE} the result will be simplified using
    \code{\link{simplify2array}}.
  }
    \item{\code{USE.NAMES}}{If \code{TRUE} the result will be named.
  }
  }}
}
\value{
Output relevant to the \code{apply_fun} specified.
}
\description{
Light wrapper around \code{\link[BiocParallel]{BiocParallel}} functions that
automatically applies appropriate parallel function.
}
\examples{
half_it <- function(arg1) return(arg1 / 2)
x <- seq_len(10)

res <- MotifPeeker:::bpapply(x, half_it)
print(res)

}
\keyword{internal}
