% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\docType{methods}
\name{accessors}
\alias{accessors}
\alias{molecules}
\alias{boundaries}
\alias{features}
\alias{segmentIDs}
\alias{molecules<-}
\alias{boundaries<-}
\alias{molecules,MoleculeExperiment-method}
\alias{boundaries,MoleculeExperiment-method}
\alias{features,MoleculeExperiment-method}
\alias{segmentIDs,MoleculeExperiment-method}
\alias{molecules<-,MoleculeExperiment-method}
\alias{boundaries<-,MoleculeExperiment-method}
\title{Accessor functions to work with MoleculeExperiment objects}
\usage{
\S4method{molecules}{MoleculeExperiment}(x, assayName = NULL, flatten = FALSE)

\S4method{boundaries}{MoleculeExperiment}(object, assayName = NULL, flatten = FALSE)

\S4method{features}{MoleculeExperiment}(object, assayName = NULL)

\S4method{segmentIDs}{MoleculeExperiment}(object, assayName = NULL)

\S4method{molecules}{MoleculeExperiment}(x, assayName = NULL) <- value

\S4method{boundaries}{MoleculeExperiment}(object, assayName = NULL) <- value
}
\arguments{
\item{x}{The MoleculeExperiment to access.}

\item{assayName}{Character string specifying the name of the assay from
which to retrieve or set information in the slot of interest.}

\item{flatten}{Logical value specifying whether to flatten the ME list into
a data.frame or not. Defaults to FALSE.}

\item{object}{The MoleculeExperiment to access.}

\item{value}{New value to be added to the slot and assay of interest.}
}
\value{
A MoleculeExperiment object slot.
}
\description{
Accessor functions to work with MoleculeExperiment objects
}
\section{getters}{

Accessor functions to get data from the MoleculeExperiment object.
These include:
\itemize{
\item molecules() to retrieve information from the molecules slot.
\item boundaries() to retrieve information from the boundaries slot.
\item features() to retrieve feature names from the molecules slot.
\item segmentIDs() to retrieve segment ids from the boundaries slot.
}
}

\section{setters}{

The \verb{molecules<-} setter accesses the molecules slot, whereas the boundaries
slot can be accessed with \verb{boundaries<-}.
}

\examples{
# get example data
repoDir <- system.file("extdata", package = "MoleculeExperiment")
repoDir <- paste0(repoDir, "/xenium_V1_FF_Mouse_Brain")
me <- readXenium(repoDir,
    keepCols = "essential",
    addBoundaries = "cell"
)

# get insight into MoleculeExperiment object (e.g., see assay names)
me

# get insight into molecules slot (e.g., see the assay names)
showMolecules(me)

# for developers, use molecules() getter
# expect a large output from call below
# molecules(me, assayName = "detected")
# alternatively, return rectangular data structure with flatten = TRUE
molecules(me, assayName = "detected", flatten = TRUE)

# get insight into boundaries slot (e.g., see the assay names)
showBoundaries(me)

# for developers, use boundaries() getter
# expect a large output from call below
# boundaries(me, assayName = "cell")
# alternatively, return rectangular data structure with flatten = TRUE
boundaries(me, assayName = "cell", flatten = TRUE)

# features() getter
features(me, assayName = "detected")

# segmentIDs() getter
segmentIDs(me, assayName = "cell")

# setter example
# read in and standardise nucleus boundaries too
nucleiMEList <- readBoundaries(
    dataDir = repoDir,
    pattern = "nucleus_boundaries.csv",
    segmentIDCol = "cell_id",
    xCol = "vertex_x",
    yCol = "vertex_y",
    keepCols = "essential",
    boundariesAssay = "nucleus",
    scaleFactorVector = 1
)

# use `boundaries<-` setter to add nucleus boundaries to the boundaries slot
boundaries(me, assayName = "nucleus") <- nucleiMEList
me
}
