% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff-analysis-utilities.R
\name{multi_compare}
\alias{multi_compare}
\title{a container for performing two or more sample test.}
\usage{
multi_compare(
  fun = wilcox.test,
  data,
  feature,
  factorNames,
  subgroup = NULL,
  ...
)
}
\arguments{
\item{fun}{character, the method for test, optional ""}

\item{data}{data.frame, nrow sample * ncol feature+factorNames.}

\item{feature}{vector, the features wanted to test.}

\item{factorNames}{character, the name of a factor giving the corresponding groups.}

\item{subgroup}{vector, the names of groups, default is NULL.}

\item{..., }{additional arguments for fun.}
}
\value{
the result of fun, if fun is wilcox.test, it 
will return the list with class "htest".
}
\description{
a container for performing two or more sample test.
}
\examples{
datest <- data.frame(A=rnorm(1:10,mean=5),
                     B=rnorm(2:11, mean=6), 
                     group=c(rep("case",5),rep("control",5)))
head(datest)
multi_compare(fun=wilcox.test,data=datest,
              feature=c("A", "B"),factorNames="group")
da2 <- data.frame(A=rnorm(1:15,mean=5),
                  B=rnorm(2:16,mean=6),
                  group=c(rep("case1",5),rep("case2",5),rep("control",5)))
multi_compare(fun=wilcox.test,data=da2,
              feature=c("A", "B"),factorNames="group",
              subgroup=c("case1", "case2"))
}
\author{
Shuangbin Xu
}
