% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_aggregate.R
\name{mp_aggregate}
\alias{mp_aggregate}
\alias{mp_aggregate,MPSE-method}
\alias{mp_aggregate,MPSE}
\title{aggregate the assays with the specific group of sample and fun.}
\usage{
mp_aggregate(.data, .abundance, .group, fun = sum, keep_colData = TRUE, ...)

\S4method{mp_aggregate}{MPSE}(.data, .abundance, .group, fun = sum, keep_colData = TRUE, ...)
}
\arguments{
\item{.data}{MPSE object, required}

\item{.abundance}{the column names of abundance, default is Abundance.}

\item{.group}{the column names of sample meta-data, required}

\item{fun}{a function to compute the summary statistics, default is sum.}

\item{keep_colData}{logical whether to keep the sample meta-data with \code{.group} as row names,
default is TRUE.}

\item{...}{additional parameters, see also \code{\link[stats]{aggregate}}.}
}
\value{
a new object with .group as column names in assays
}
\description{
aggregate the assays with the specific group of sample and fun.
}
\examples{
\dontrun{
data(mouse.time.mpse)
newmpse <- mouse.time.mpse \%>\%
           mp_aggregate(.group = time)
newmpse
}
}
