% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Download_Preprocess.R
\name{ClusterProbes}
\alias{ClusterProbes}
\title{The ClusterProbes function}
\usage{
ClusterProbes(MET_Cancer, MET_Normal, CorThreshold = 0.4)
}
\arguments{
\item{MET_Cancer}{data matrix for cancer samples.}

\item{MET_Normal}{data matrix for normal samples.}

\item{CorThreshold}{correlation threshold for cutting the clusters.}
}
\value{
List with the clustered data sets and the mapping between probes and genes.
}
\description{
This function uses the annotation for Illumina methylation arrays to map each probe to a gene. Then, for each gene,
it clusters all its CpG sites using hierchical clustering and Pearson correlation as distance and complete linkage. 
If data for normal samples is provided, only overlapping probes between cancer and normal samples are used. 
Probes with SNPs are removed. 
This function is prepared to run in parallel if the user registers a parallel structure, otherwise it runs sequentially.
This function also cleans up the sample names, converting them to the 12 digit format.
}
\examples{
\dontrun{

# Optional register cluster to run in parallel
library(doParallel)
cl <- makeCluster(5)
registerDoParallel(cl)

# Methylation data for ovarian cancer
cancerSite <- "OV"
targetDirectory <- paste0(getwd(), "/")

# Downloading methylation data
METdirectories <- Download_DNAmethylation(cancerSite, targetDirectory, TRUE)

# Processing methylation data
METProcessedData <- Preprocess_DNAmethylation(cancerSite, METdirectories)

# Saving methylation processed data
saveRDS(METProcessedData, file = paste0(targetDirectory, "MET_", cancerSite, "_Processed.rds"))

# Clustering methylation data
res <- ClusterProbes(METProcessedData[[1]], METProcessedData[[2]])

# Saving methylation clustered data
toSave <- list(METcancer = res[[1]], METnormal = res[[2]], ProbeMapping = res$ProbeMapping)
saveRDS(toSave, file = paste0(targetDirectory, "MET_", cancerSite, "_Clustered.rds"))

stopCluster(cl)
}
 
}
\keyword{cluter_probes}
