% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\docType{methods}
\name{visualize}
\alias{visualize}
\alias{visualize,summarizedData-method}
\title{visualize the summarized Illumina Human DNA Methylation
    array data}
\usage{
visualize(object, thresholds = list(hm450k = list(MU = 10.5, OP = 11.75, BS =
  12.75, HC = 13.25, DP = 0.95), epic = list(MU = 10, OP = 12, BS = 11.75, HC =
  12.75, DP = 0.95)), background = NULL, ...)

\S4method{visualize}{summarizedData}(object, thresholds = list(hm450k =
  list(MU = 10.5, OP = 11.75, BS = 12.75, HC = 13.25, DP = 0.95), epic = list(MU
  = 10, OP = 12, BS = 11.75, HC = 12.75, DP = 0.95)), background = NULL, ...)
}
\arguments{
\item{object}{summarizedData object}

\item{thresholds}{default thresholds}

\item{background}{optional summarizedData-object used as
background in filter control plots}

\item{...}{for future use}
}
\value{
lauches a web browser with the shiny application and
    returns a data.frame with detected outliers
}
\description{
launch a shiny app for visualization of the summarized Illumina
Human DNA Methylation array data
}
\details{
Outliers are detected based on a set of default thresholds.  To
use a use-defined set of thresholds use the thresholds argument.
}
\examples{
library(minfiData)
baseDir <- system.file("extdata", package="minfiData")
targets <- read.metharray.sheet(baseDir)
data <- summarize(targets)
\dontrun{
visualize(data)
}
}
