% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adducts.R
\name{adductNames}
\alias{adductNames}
\alias{adducts}
\title{Retrieve names of supported adducts}
\usage{
adductNames(polarity = c("positive", "negative"))

adducts(polarity = c("positive", "negative"))
}
\arguments{
\item{polarity}{\code{character(1)} defining the ion mode, either \code{"positive"} or
\code{"negative"}.}
}
\value{
for \code{adductNames}: \code{character} vector with all valid adduct names
for the selected ion mode. For \code{adducts}: \code{data.frame} with the adduct
definitions.
}
\description{
\code{adductNames} returns all supported adduct definitions that can be used by
\code{\link[=mass2mz]{mass2mz()}} and \code{\link[=mz2mass]{mz2mass()}}.

\code{adducts} returns a \code{data.frame} with the adduct definitions.
}
\examples{

## retrieve names of adduct names in positive ion mode
adductNames(polarity = "positive")

## retrieve names of adduct names in negative ion mode
adductNames(polarity = "negative")
}
\author{
Michael Witting, Johannes Rainer
}
