% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_check.R
\name{data_check}
\alias{data_check}
\title{Data Check}
\usage{
data_check(
  count,
  meta,
  covariates = "all",
  distance_matrix = NULL,
  tree = NULL,
  taxonomy = NULL,
  tax_level = NULL,
  verbose = TRUE
)
}
\arguments{
\item{count}{The integrated count table of taxa by samples. The
\code{count} parameter should be provided as either a \code{matrix} or a
\code{data.frame}.}

\item{meta}{The integrated meta table \code{meta} contains sample information
and batch id.}

\item{covariates}{The covariates used in data integration. Default is all.}

\item{distance_matrix}{The distance matrix that measures sequence dissimilarity.}

\item{tree}{The phylogenetic tree (optional if distance matrix or taxonomy is provided).}

\item{taxonomy}{The taxonomy table (optional if distance matrix or phylogenetic tree is provided).}

\item{tax_level}{The taxonomic level of count table.}

\item{verbose}{Logical; whether to print progress messages. Default is TRUE.}
}
\value{
a \code{list} contains count list, meta table list, sequencing distance
matrix and parameters.
}
\description{
Check the format of inputs.
}
