% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGA.R
\name{plotGA}
\alias{plotGA}
\title{Plot the result from the glmAnalysis function}
\usage{
plotGA(GA, size = 16)
}
\arguments{
\item{GA}{A data frame returned from the function glmAnalysis.}

\item{size}{The font size of texts in the plot}
}
\value{
The plot will show up automatically.
}
\description{
A function that plots the result from the glmAnalysis function.
}
\examples{
library(dplyr)
#collect all summary statistics
fn=system.file("extdata","",package="MetaCyto")
files=list.files(fn,pattern="cluster_stats_in_each_sample",recursive=TRUE,
                full.names=TRUE)
fcs_stats=collectData(files,longform=TRUE)
# Collect sample information
files=list.files(fn,pattern="sample_info",recursive=TRUE,full.names=TRUE)
sample_info=collectData(files,longform=FALSE)
# join the cluster summary statistics with sample information
all_data=inner_join(fcs_stats,sample_info,by="fcs_files")
# See the fraction of what clusters are affected
# by age (while controlling for Gender)
GA=glmAnalysis(value="value",variableOfInterst="Subject Age",
             parameter="fraction",
              otherVariables=c("Gender"),studyID="study_id",label="label",
              data=all_data,CILevel=0.95,ifScale=c(TRUE,FALSE))
GA=GA[order(GA$Effect_size),]
# plot the effect sizes
plotGA(GA)
}
