% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdata_database_class.R
\name{rdata_database}
\alias{rdata_database}
\title{rdata database}
\usage{
rdata_database(source = character(0), variable_name, ...)
}
\arguments{
\item{source}{(ANY) The source of annotation data. The default is
\code{character(0)}.}

\item{variable_name}{(character, function) The name of the data.frame
in the imported workspace to use as the data.frame for this source. A
function can be provided to e.g. extract a data.frame from a list in
the imported environment.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
rdata_database
} object. This object has no \code{output} slots.
}
\description{
A data.frame stored as an RData file.
}
\section{Inheritance}{

A \code{rdata_database} object inherits the following \code{struct} classes:
\cr\cr
\verb{[rdata_database]} -> \verb{[annotation_database]} ->
\verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- rdata_database(
        variable_name = "a data frame",
        tag = character(0),
        data = data.frame(),
        source = "ANY")

}
\seealso{
Other annotation databases: 
\code{\link{AnnotationDb_database}},
\code{\link{GO_database}},
\code{\link{annotation_database}},
\code{\link{annotation_source}},
\code{\link{excel_database}},
\code{\link{rds_cache}},
\code{\link{rds_database}}
}
\concept{annotation databases}
