% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_count_class.R
\name{id_counts}
\alias{id_counts}
\title{id counts}
\usage{
id_counts(id_column, count_column = "id_counts", count_na = TRUE, ...)
}
\arguments{
\item{id_column}{(character) Column name of the variable ids in
variable_meta.}

\item{count_column}{(character) The name of the new column to store
the counts in. The default is \code{"id_counts"}.}

\item{count_na}{(logical) Count NA. Allowed values are limited to the
following: \itemize{ \item{\code{"TRUE"}: Report number of
NA.}\item{\code{"FALSE"}: Do not report number of NA.}} The default
is \code{TRUE}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{id_counts} object with the following \code{output}
slots:
\tabular{ll}{
\code{updated} \tab (annotation_source) The input annotation source
with the newly generated column. \cr
}
}
\description{
Adds the number of times an identical identifier is
present to each record.
}
\section{Inheritance}{

A \code{id_counts} object inherits the following \code{struct} classes: \cr\cr
\verb{[id_counts]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- id_counts(
        id_column = character(0),
        count_column = character(0),
        count_na = FALSE)

}
