% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyApp.R
\name{typeMatch_link0}
\alias{typeMatch_link0}
\title{Get typeMatch and link0 data frame}
\usage{
typeMatch_link0(similarityMatrix, sps, type, condition)
}
\arguments{
\item{similarityMatrix}{\code{matrix} with pairwise similarity values}

\item{sps}{\code{Spectra} object}

\item{type}{\code{character(1)}, either \code{"mz"}, \code{"retentionTime"}, 
\code{"clustering"}}

\item{condition}{\code{character}}
}
\value{
\code{list} of length 2,  entry \code{link0df} is a \code{data.frame} and 
entry \code{type_match} is a \code{character} vector
}
\description{
\code{typeMatch_link0} returns a list with accessors \code{"link0df"} and
\code{"type_match"}
}
\details{
Helper function for \code{shinyCircos}.
}
\examples{
data("spectra", package = "MetCirc")
similarityMat <- Spectra::compareSpectra(sps_tissue[1:10],
    FUN = MsCoreUtils::ndotproduct, ppm = 10, m = 0.5, n = 2)
rownames(similarityMat) <- colnames(similarityMat) <- sps_tissue$name[1:10]

## order according to retention time 
MetCirc:::typeMatch_link0(similarityMatrix = similarityMat, 
    sps = sps_tissue, type = "mz", 
    condition = c("SPL", "LIM", "ANT", "STY"))

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
