% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkDf.R
\name{thresholdLinkDf}
\alias{thresholdLinkDf}
\title{Threshold a data frame containing information on links}
\usage{
thresholdLinkDf(link0df, lower = 0.75, upper = 1)
}
\arguments{
\item{link0df}{\code{data.frame}, a link data frame that gives per each row
information on linked features}

\item{lower}{\code{numeric}, threshold value for similarity values, below
this value linked features will not be returned}

\item{upper}{\code{numeric}, threshold value for similarity values, above
this value linked features will not be returned}
}
\value{
\code{thresholdLinkDf} returns a \code{data.frame} that gives per each row
information on linked features which are linked within certain thresholds.
}
\description{
Threshold a link data frame based on lower and upper similarity values. 
The function will return the links that lie within the defined bounds.
}
\details{
\code{lower} and \code{upper} are numerical values
and truncate mass spectra based on their similarity values.
}
\examples{
data("spectra", package = "MetCirc")
data("similarityMat", package = "MetCirc")
link0df <- createLink0df(similarityMatrix = similarityMat,
    sps_tissue, condition = c("SPL", "LIM", "ANT", "STY"))
thresholdLinkDf(link0df = link0df, lower = 0.5, upper = 1)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
