% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_de.R
\name{volcanoPlot}
\alias{volcanoPlot}
\title{Volcano plot of fold changes/differences against p-values}
\usage{
volcanoPlot(df, type = c("ttest", "proDA"))
}
\arguments{
\item{df}{\code{data.frame} as received from \code{topTable} (\code{ttest}) 
or \code{test_diff} (proDA)}

\item{type}{\code{character}}
}
\value{
\code{plotly}
}
\description{
The function \code{ComplexHeatmap} creates a volcano plot. On the y-axis the
-log10(p-values) are displayed, while on the x-axis the fold 
changes/differences are displayed.
The output of the function  differs depending on the
\code{type} parameter. For \code{type == "ttest"}, the fold changes are 
plotted; for \code{type == "proDA"}, the  differences are plotted.
}
\details{
Internal use in \code{shinyQC}.
}
\examples{
## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
set.seed(1)
a <- a + rnorm(100)
a_i <- imputeAssay(a, method = "MinDet")
cD <- data.frame(sample = colnames(a), 
    type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
                                rowData = rD, colData = cD)
se_i <- SummarizedExperiment::SummarizedExperiment(assay = a_i, 
                                rowData = rD, colData = cD)

## create model and contrast matrix
modelMatrix_expr <- stats::formula("~ 0 + type")
contrast_expr <- "type1-type2"
modelMatrix <- model.matrix(modelMatrix_expr, data = colData(se))
contrastMatrix <- limma::makeContrasts(contrasts = contrast_expr, 
                                levels = modelMatrix)

## ttest
fit <- limma::lmFit(a_i, design = modelMatrix)
fit <- limma::contrasts.fit(fit, contrastMatrix)
fit <- limma::eBayes(fit, trend = TRUE)
df_ttest <- limma::topTable(fit, n = Inf, adjust = "fdr", p = 0.05)
df_ttest <- cbind(name = rownames(df_ttest), df_ttest)

## plot
volcanoPlot(df_ttest, type = "ttest")

## proDA
\donttest{
fit <- proDA::proDA(a, design = modelMatrix)
df_proDA <- proDA::test_diff(fit = fit, contrast = contrast_expr,
        sort_by = "adj_pval")

## plot
volcanoPlot(df_proDA, type = "proDA")
}

}
