% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_samplesfeatures.R
\name{mosaic}
\alias{mosaic}
\title{Mosaic plot for two factors in colData(se)}
\usage{
mosaic(se, f1, f2)
}
\arguments{
\item{se}{\code{SummarizedExperiment} object}

\item{f1}{\code{character}, \code{f1} is one of the column names in \code{colData(se)}}

\item{f2}{\code{character}, \code{f2} is one of the column names in \code{colData(se)}}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
The function \code{mosaic} creates a mosaic plot of two factors from
an \code{SummarizedExperiment} object. The columns \code{f1} and \code{f2} 
are taken from \code{colData(se)}.
}
\details{
Code partly taken from
https://stackoverflow.com/questions/21588096/pass-string-to-facet-grid-ggplot2
}
\examples{
## create se
set.seed(1)
a <- matrix(rnorm(100), nrow = 10, ncol = 10,
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
cD <- data.frame(name = colnames(a), 
    type = c(rep("1", 5), rep("2", 5)),
    cell_type = c("A", "B"))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

mosaic(se, "cell_type", "type")

}
