% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_measuredvalues_missingvalues.R
\name{measuredCategory}
\alias{measuredCategory}
\title{Obtain the number of measured intensities per sample type}
\usage{
measuredCategory(se, measured = TRUE, category = "type")
}
\arguments{
\item{se}{\code{SummarizedExperiment}}

\item{measured}{\code{logical}, should the measured values 
(\code{measured = TRUE}) or missing values (\code{measured = FALSE}) 
be taken}

\item{category}{\code{character}, corresponds to a column name in 
\code{colData(se)}}
}
\value{
\code{matrix} with number of measured/missing features per 
\code{category} type
}
\description{
The function \code{measuredCategory} creates a \code{tbl} with
the number of measured values per feature. 0 means that there were only 
missing values (\code{NA}) for the feature and sample type. 
\code{measuredCategory} will return a \code{tbl} where columns are the 
unique sample types and rows are the features as in \code{assay(se)}.
}
\details{
\code{measuredCategory} is a helper function.
}
\examples{
## create se
set.seed(1)
a <- matrix(rnorm(100), nrow = 10, ncol = 10,
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a,
    rowData = rD, colData = cD)

measuredCategory(se, measured = TRUE, category = "type")

}
