% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_samplesfeatures.R
\name{hist_sample_num}
\alias{hist_sample_num}
\title{Return the number of a category}
\usage{
hist_sample_num(se, category = "type")
}
\arguments{
\item{se}{\code{SummarizedExperiment} object}

\item{category}{\code{character}, corresponding to a column in \code{colData(se)}}
}
\value{
\code{tbl}
}
\description{
\code{hist_sample_num} returns the number of a category 
(e.g. sample types) as a \code{tbl}.
The function will retrieve first the column \code{category} in \code{colData(se)}. 
The function will return a \code{tbl} containing the numerical 
values of the quantities.
}
\examples{
## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
    dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
set.seed(1)
a <- a + rnorm(100)
cD <- data.frame(name = colnames(a), type = c(rep("1", 4), rep("2", 6)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

hist_sample_num(se, category = "type")

}
