\name{calcMW}
\alias{calcMW}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Calculate molecular weight }
\description{
  Function to calculate molecular weight of a fragment generated by the MassCLEAVE assay for either the T or C cleavage reactions
}
\usage{
calcMW(sequence, extra = c("5OH", "5PPP-3P", "5PPP-3OH"), adduct = c("", "Na", "K"), rxn = c("T", "C"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{sequence}{ Nucleotide sequence input }
  \item{extra}{ One of "5OH" (default), "5PPP-3P", or "5PPP-3OH" describing 5' and/or 3' modifications of the fragment}
  \item{adduct}{ One of 'Na', 'K', or '' (default) specifying whether or not the molecular weight should be calculated for a salt adduct }
  \item{rxn}{ One of 'T' or 'C' indicating which cleavage reaction is employed to generate the fragment }
}
\value{
  Returns a numerical output corresponding to the molecular weight (in Da) of sequence input. Note that the output may actually represent multiple molecular weights 
  if/whenever the input sequence contains one or more degenerate bases (e.g. R or Y).
}
\author{  Reid F. Thompson (\email{rthompso@aecom.yu.edu}), John M. Greally (\email{jgreally@aecom.yu.edu})  }
\examples{
calcMW("AAATCCC")
calcMW("AARTYCC")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ character }
\keyword{ arith }
