% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparisonPlots.R
\name{.plotVolcano}
\alias{.plotVolcano}
\title{Preprocess data for volcano plots and create them}
\usage{
.plotVolcano(
  input,
  which.Comparison,
  address,
  width,
  height,
  log_base_pval,
  ylimUp,
  ylimDown,
  FCcutoff,
  sig,
  xlimUp,
  ProteinName,
  dot.size,
  text.size,
  legend.size,
  x.axis.size,
  y.axis.size,
  log_base_FC,
  isPlotly
)
}
\arguments{
\item{which.Comparison}{list of comparisons to draw plots. List can be labels of comparisons or order numbers of comparisons from levels(data$Label), such as levels(testResultMultiComparisons$ComparisonResult$Label). Default is "all", which generates all plots for each protein.}

\item{address}{the name of folder that will store the results. Default folder is the current working directory. The other assigned folder has to be existed under the current working directory. An output pdf file is automatically created with the default name of "VolcanoPlot.pdf" or "Heatmap.pdf" or "ComparisonPlot.pdf". The command address can help to specify where to store the file as well as how to modify the beginning of the file name. If address=FALSE, plot will be not saved as pdf file but showed in window.}

\item{width}{width of the saved file in pixels. Default is 800.}

\item{height}{height of the saved file in pixels. Default is 600.}

\item{ylimUp}{for all three plots, upper limit for y-axis. FALSE (default) for volcano plot/heatmap use maximum of -log2 (adjusted p-value) or -log10 (adjusted p-value). FALSE (default) for comparison plot uses maximum of log-fold change + CI.}

\item{ylimDown}{for all three plots, lower limit for y-axis. FALSE (default) for volcano plot/heatmap use minimum of -log2 (adjusted p-value) or -log10 (adjusted p-value). FALSE (default) for comparison plot uses minimum of log-fold change - CI.}

\item{FCcutoff}{for volcano plot or heatmap, whether involve fold change cutoff or not. FALSE (default) means no fold change cutoff is applied for significance analysis. FCcutoff = specific value means specific fold change cutoff is applied.}

\item{sig}{FDR cutoff for the adjusted p-values in heatmap and volcano plot. level of significance for comparison plot. 100(1-sig)\% confidence interval will be drawn.  sig=0.05 is default.}

\item{xlimUp}{for Volcano plot, the limit for x-axis. FALSE (default) for  use maximum for absolute value of log-fold change or 3 as default if maximum for absolute value of log-fold change is less than 3.}

\item{ProteinName}{for volcano plot only, whether display protein names or not. TRUE (default) means protein names, which are significant, are displayed next to the points. FALSE means no protein names are displayed.}

\item{dot.size}{size of dots in volcano plot and comparison plot. Default is 3.}

\item{text.size}{size of ProteinName label in the graph for Volcano Plot. Default is 4.}

\item{legend.size}{size of legend for color at the bottom of volcano plot.  Default is 7.}

\item{x.axis.size}{size of axes labels, e.g. name of the comparisons in heatmap, and in comparison plot. Default is 10.}

\item{y.axis.size}{size of axes labels, e.g. name of targeted proteins in heatmap. Default is 10.}

\item{isPlotly}{This parameter is for MSstatsShiny application for plotly 
render, this cannot be used for saving PDF files as plotly do not have 
suppprt for PDFs currently. address and isPlotly cannot be set as TRUE at the
same time.}
}
\description{
Preprocess data for volcano plots and create them
}
\keyword{internal}
