% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_summarization_methods.R
\name{MSstatsSummarizeTMT}
\alias{MSstatsSummarizeTMT}
\title{Protein summarization for TMT data}
\usage{
MSstatsSummarizeTMT(
  input,
  method,
  impute,
  max_quantile_censored = NULL,
  log_file_path = NULL
)
}
\arguments{
\item{input}{data.table with TM quant data}

\item{method}{Four different summarization methods to protein-level 
can be performed : "msstats"(default), "MedianPolish", "Median", "LogSum".}

\item{impute}{only for method="msstats". TRUE (default) imputes missing 
values by Accelated failure model. FALSE uses minimum value to impute the 
missing value for each peptide precursor ion.}

\item{max_quantile_censored}{We assume missing values are censored. 
maxQuantileforCensored is Maximum quantile for deciding censored missing 
value, for instance, 0.999. Default is Null.}

\item{log_file_path}{path to a MSstats log file}
}
\value{
data.table
}
\description{
Protein summarization for TMT data
}
\keyword{internal}
