% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_calculations.R
\name{lf_summarization_loop}
\alias{lf_summarization_loop}
\title{Main LF calculation summarization function for MSstatsShiny application}
\usage{
lf_summarization_loop(data, qc_input, loadpage_input, busy_indicator = TRUE)
}
\arguments{
\item{data}{Data converted into MSstats format.}

\item{qc_input}{options for data processing input by the user from data processing page.}

\item{loadpage_input}{options for data processing input by the user from data upload page.}

\item{busy_indicator}{Boolean indicator indicating whether or not to display
shiny waiting indicator.}
}
\value{
list of LF Summarization results
}
\description{
Main LF function to calculate MSstatsShiny results.
}
\examples{
data("example_dia_skyline")
data("example_skyline_annotation")
testdata = MSstats::SkylinetoMSstatsFormat(example_dia_skyline,
                                            annotation = example_skyline_annotation,
                                            filter_with_Qvalue = TRUE, 
                                            qvalue_cutoff = 0.01, 
                                            fewMeasurements="remove", 
                                            removeProtein_with1Feature = TRUE,
                                            use_log_file = FALSE)

## Source app functionality
qc_input = list()
loadpage_input = list()
qc_input$norm = "equalizeMedians"
qc_input$log = 2
qc_input$names = NULL
qc_input$features_used	= "all"
code_n_feat=3
qc_input$censInt = "NA"
qc_input$MBi = TRUE
qc_input$remove50 = FALSE
qc_input$maxQC = 0.999
qc_input$null = FALSE
qc_input$null1 = FALSE
qc_input$summaryMethod = "TMP"
loadpage_input$DDA_DIA = "LF"
lf_summarization_loop(testdata, qc_input,loadpage_input, busy_indicator=FALSE)

}
