% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DecisionMap.R
\name{DecisionMap}
\alias{DecisionMap}
\title{A function to create heatmaps to compare performance with user defined performance criteria}
\usage{
DecisionMap(
  data = NULL,
  method = "XmR",
  peptideThresholdRed = 0.7,
  peptideThresholdYellow = 0.5,
  L = 1,
  U = 5,
  type = "mean",
  title = "heatmap plot",
  listMean = NULL,
  listSD = NULL
)
}
\arguments{
\item{data}{Comma-separated (*.csv), QC file format. It should contain a Precursor
column and the metrics columns.}

\item{method}{It is either "CUSUM" or "XmR"}

\item{peptideThresholdRed}{Is a threshold that marks percentage of peptides above it
red on the heatmap. Defaults to 0.7}

\item{peptideThresholdYellow}{Is a threshold that marks percentage of peptides above
it and below the peptideThresholdRed, yellow on the heatmap. Defaults to 0.5}

\item{L}{Lower bound of the giude set. Defaults to 1}

\item{U}{Upper bound of the guide set. Defaults to 5}

\item{type}{can take two values, "mean" or "dispersion". Defaults to "mean"}

\item{title}{the title of the plot. Defaults to "heatmap plot"}

\item{listMean}{List of the means for the metrics. If you don't know the means leave
it as NULL and they will be calculated automatically by using L and U. The default is NULL.}

\item{listSD}{List of the standard deviations for the metrics. If you don't know the
standard deviations leave it as NULL and they will be calculated automatically by using L and U.
 The default is NULL.}
}
\value{
A heatmap to aggregate results per metric generated from \code{heatmap.DataFrame} data frame.
}
\description{
A function to create heatmaps to compare performance with user defined performance criteria
}
\examples{
# First process the data to make sure it's ready to use
sampleData <- DataProcess(S9Site54)
head(sampleData)
# Draw Decision maker plot
DecisionMap(data = sampleData, method = "CUSUM")
DecisionMap(data = sampleData, method = "CUSUM", type = "variability")
DecisionMap(data = sampleData, method = "XmR")
DecisionMap(data = sampleData, method = "XmR", type = "variability")
}
\keyword{heatmap}
