% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{SpectronauttoMSstatsPTMFormat}
\alias{SpectronauttoMSstatsPTMFormat}
\title{Convert Spectronaut output into MSstatsPTM format}
\usage{
SpectronauttoMSstatsPTMFormat(
  input,
  annotation = NULL,
  fasta_path = NULL,
  protein_input = NULL,
  annotation_protein = NULL,
  use_unmod_peptides = FALSE,
  intensity = "PeakArea",
  mod_id = "\\\\[Phospho \\\\(STY\\\\)\\\\]",
  fasta_protein_name = "uniprot_iso",
  remove_other_mods = TRUE,
  filter_with_Qvalue = TRUE,
  qvalue_cutoff = 0.01,
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeProtein_with1Feature = FALSE,
  summaryforMultipleRows = max,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{input}{name of Spectronaut PTM output, which is long-format.
ProteinName, PeptideSequence, PrecursorCharge, FragmentIon, ProductCharge,
IsotopeLabelType, Condition, BioReplicate, Run, Intensity,
F.ExcludedFromQuantification are required. Rows with
F.ExcludedFromQuantification=True will be removed.}

\item{annotation}{name of 'annotation.txt' data which includes Condition,
BioReplicate, Run. If annotation is already complete in Spectronaut,
use annotation=NULL (default). It will use the annotation information from
input.}

\item{fasta_path}{string containing path to the corresponding fasta file for
the modified peptide dataset.}

\item{protein_input}{name of Spectronaut global protein output, which is
as in the same format as \code{input} parameter.}

\item{annotation_protein}{name of annotation file for global protein data, in
the same format as above.}

\item{use_unmod_peptides}{If \code{protein_input} is not provided,
unmodified peptides can be extracted from \code{input} to be used in place of a
global profiling run. Default is \code{FALSE}.}

\item{intensity}{'PeakArea'(default) uses not normalized peak area.
'NormalizedPeakArea' uses peak area normalized by Spectronaut. Default is
NULL}

\item{mod_id}{Character that indicates the modification of interest. Default
is \verb{\\\\(Phospho\\\\)}. Note \verb{\\\\} must be included before special characters.}

\item{fasta_protein_name}{Name of fasta column that matches with protein name
in evidence file. Default is \code{uniprot_iso}.}

\item{remove_other_mods}{Remove peptides which include modfications other
than the one listed in \code{mod_id}. Default is \code{TRUE}. For example, in an
experiment targeting Phosphorylation, setting this parameter to \code{TRUE} would
remove peptides like
(Acetyl (Protein N-term))AAAAPDSRVS(Phospho (STY))EEENLK. Set this parameter
to \code{FALSE} to keep peptides with extraneous modifications.}

\item{filter_with_Qvalue}{TRUE(default) will filter out the intensities that
have greater than qvalue_cutoff in EG.Qvalue column. Those intensities will
be replaced with zero and will be considered as censored missing values for
imputation purpose.}

\item{qvalue_cutoff}{Cutoff for EG.Qvalue. Default is 0.01.}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned for
more than one proteins. We assume to use unique peptide for each protein.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that
have 1 or 2 measurements across runs.}

\item{removeProtein_with1Feature}{TRUE will remove the proteins which have
only 1 feature, which is the combination of peptide, precursor charge,
fragment and charge. FALSE is default.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple
measurements for certain feature and certain run, use highest or sum of
multiple intensities.}

\item{use_log_file}{logical. If TRUE, information about data processing will
be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved. If not provided, such a file will be created
automatically. If 'append = TRUE', has to be a valid path to a file.}
}
\value{
a list of two data.tables named 'PTM' and 'PROTEIN' in the format
required by MSstatsPTM.
}
\description{
Converters label-free Spectronaut data into MSstatsPTM format. Requires PSM
output from Spectronaut and a custom made annotation file, mapping the run
name to the condition and bioreplicate. Can optionally take a seperate PSM
file for a global profiling run. If no global profiling run provided, the
function can extract the unmodified peptides from the PTM PSM file and use
them as a global profiling run (not recommended).
}
\examples{

head(spectronaut_input)
head(spectronaut_annotation)

msstats_input = SpectronauttoMSstatsPTMFormat(spectronaut_input, 
                  annotation=spectronaut_annotation, 
                  fasta_path=system.file("extdata", "spectronaut_fasta.fasta", package="MSstatsPTM"),
                  use_unmod_peptides=TRUE,
                  mod_id = "\\\\[Phospho \\\\(STY\\\\)\\\\]",
                  fasta_protein_name = "uniprot_iso"
                  )

head(msstats_input$PTM)
head(msstats_input$PROTEIN)
}
