% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{spikeindata}
\alias{spikeindata}
\title{Example of normalized datasets from raw_data,}
\format{A data frame with 30 rows and 4 variables.}
\usage{
spikeindata
}
\description{
We normalize the intensity of the light peptides using that of the heavy peptides.
This corrects any systematic errors that can occur during a run or across replicates.
The calculation is greatly simplified by the use of the tidyr and dplyr packages.
The area from all the different peptide fragments is first summed then log transformed.
The median intensity of the reference heavy peptides medianlog2heavy is calculated.
Their intensities should ideally remain constant across runs
since the spiked concentration of the heavy peptide is constant.
The difference between the median for all the heavy peptide spikes is calculated.
It is then used to correct (i.e. to normalize) the intensity of the light peptides log2light
to obtain the adjusted intensity log2light_norm.
The intensity is finally converted back to original space.
Details are available in vignette.
The variables are as follows:
}
\details{
\itemize{
\item CONCENTRATION: Concentration values at which the value of the fit is calculated
\item MEAN: The value of the curve fit
\item LOW: The value of the lower bound of the 95\\% prediction interval
\item UP: The value of the upper bound of the 95\\% prediction interval
\item LOB: The value of the LOB (one column with identical values)
\item LOD: The value of the LOD (one column with identical values)
\item SLOPE: Value of the slope of the linear curve fit where only the spikes above LOD are considered
\item INTERCEPT: Value of the intercept of the linear curve fit where only the spikes above LOD are considered
\item NAME: The name of the assay (identical to that provided in the input)
\item METHOD which is always set to NONLINEAR when this function is used.
\item Each line of the data frame corresponds to a unique concentration value
at which the value of the fit and prediction interval are evaluated.
\item More unique concentrations values than in the input data frame are used to increase the accuracy of the LOB/D calculations.
}
}
\examples{
head(spikeindata)

}
\keyword{datasets}
