% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_filtering.R
\name{.filterByScore}
\alias{.filterByScore}
\title{Filter PSMs / proteins by a given score column.}
\usage{
.filterByScore(
  input,
  score_column,
  score_threshold,
  direction,
  behavior,
  handle_na = "keep",
  fill_value = NA,
  filter = TRUE,
  drop = TRUE
)
}
\arguments{
\item{input}{\code{data.table} preprocessed by one of the .cleanRaw* functions.}

\item{score_column}{chr, name of the column that contains scores.}

\item{score_threshold}{num, values below or above this threshold will be
removed from the data.}

\item{direction}{chr, if "greater" only values above the threshold will be
retained, if "smaller" - below the threshold.}

\item{behavior}{chr, if "remove", values below/above the threshold will be
removed, if "replace", they will be set to \code{fill_value}.}

\item{fill_value}{if \code{behavior} = "replace", values below/above the threshold
will be replaced with \code{fill_value}. Defaults to \code{NA}.}

\item{filter}{If TRUE, filtering will be performed.}

\item{drop}{if TRUE, \code{score_column} will be removed.}
}
\value{
data.table
}
\description{
Filter PSMs / proteins by a given score column.
}
\keyword{internal}
