TMT10 <- TMT10HCD <-
    new("ReporterIons",
        description = "10-plex TMT HCD",
        name = "TMT10HCD",
        reporterNames = c("126", "127N", "127C", "128N", "128C",
                          "129N", "129C", "130N", "130C", "131"),
        mz = c(126.127725, ## 126
               127.12476,  ## 127N
               127.131079, ## 127C
               128.128114, ## 128N
               128.134433, ## 128C
               129.131468, ## 129N
               129.137787, ## 129C
               130.134822, ## 130N
               130.141141, ## 130C
               131.138176  ## 131
               ),
        col = c(
            "#8DD3C7", "#FFFFB3", "#BEBADA", "#FB8072",
            "#80B1D3", "#FDB462", "#B3DE69", "#FCCDE5",
            "#D9D9D9", "#BC80BD"),
        width = 0.002)

TMT10ETD <- new("ReporterIons",
                description = "10-plex TMT ETD",
                name = "TMT10ETD",
                reporterNames = c("126", "127N", "127C", "128N",
                                  "128C", "129N", "129C", "130N",
                                  "130C", "131"),
                mz = c(
                    114.127725, ## 126
                    115.12476,  ## 127N
                    114.127725, ## 127C
                    115.12476, ## 128N
                    116.134433, ## 128C
                    117.131468, ## 129N
                    116.134433, ## 129C
                    117.131468, ## 130N
                    118.141141, ## 130C
                    119.138176  ## 131
                ),
                col = c(
                    "#8DD3C7", "#FFFFB3", "#BEBADA", "#FB8072",
                    "#80B1D3", "#FDB462", "#B3DE69", "#FCCDE5",
                    "#D9D9D9", "#BC80BD"),
                width = 0.002)


## ## See issue 36 for the origin of these values
## m10 <- matrix(c(0  , 0   , 5.0 , 0  ,
##                 0  , 0.2 , 5.8 , 0  ,
##                 0  , 0.3 , 4.8 , 0  ,
##                 0  , 0.4 , 4.1 , 0  ,
##                 0  , 0.6 , 3.0 , 0  ,
##                 0  , 0.8 , 3.5 , 0  ,
##                 0  , 1.4 , 2.4 , 0  ,
##                 0.1, 1.5 , 2.4 , 3.2,
##                 0  , 1.7 , 1.8 , 0  ,
##                 0.2, 2.0 , 2.2 , 0   ),
##               nrow = 10, byrow = TRUE)
## colnames(m10) <- c("-2", "-1", "1", "2")
## rownames(m10) <- reporterNames(TMT10)
## m10 <- m10/100

## ## Build extended impurity matrix
## M <- diag(1 - rowSums(m10))
## colnames(M) <- rownames(M) <- reporterNames(TMT10)
## M["126" , "127C"] <- m10["126", "1"]
## M["126" , "128C"] <- m10["126", "2"]
## M["127N", "128N"] <- m10["127N", "1"]
## M["127N", "129N"] <- m10["127N", "2"]
## M["127C", "128C"] <- m10["127C", "1"]
## M["127C", "129C"] <- m10["127C", "2"]
## M["127C", "126"]  <- m10["127C", "-1"]
## M["128N", "129N"] <- m10["128N", "1"]
## M["128N", "130N"] <- m10["128N", "2"]
## M["128N", "127N"] <- m10["128N", "-1"]
## M["128C", "129C"] <- m10["128C", "1"]
## M["128C", "130C"] <- m10["128C", "2"]
## M["128C", "127C"] <- m10["128C", "-1"]
## M["128C", "126" ] <- m10["128C", "-2"]
## M["129N", "130N"] <- m10["129N", "1"]
## M["129N", "131" ] <- m10["129N", "2"]
## M["129N", "128N"] <- m10["129N", "-1"]
## M["129N", "127N"] <- m10["129N", "-2"]
## M["129C", "130C"] <- m10["129C", "1"]
## M["129C", "128C"] <- m10["129C", "-1"]
## M["129C", "127C"] <- m10["129C", "-2"]
## M["130N", "131" ] <- m10["130N", "1"]
## M["130N", "129N"] <- m10["130N", "-1"]
## M["130N", "128N"] <- m10["130N", "-2"]
## M["130C", "129C"] <- m10["130C", "-1"]
## M["130C", "128C"] <- m10["130C", "-2"]
## M["131", "130N"] <- m10["131", "-1"]
## M["131", "129N"] <- m10["131", "-2"]
## M
## dput(M)
